/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.sis.common.dhc;

import eu.nets.sis.common.dhc.DHCConfig;
import eu.nets.sis.common.dhc.DHCResponse;
import eu.nets.sis.common.dhc.exceptions.DHCConfigException;
import eu.nets.sis.common.dhc.exceptions.DHCCredentialException;
import eu.nets.sis.common.dhc.types.DHCException;
import eu.nets.sis.common.dhc.types.NameValuePair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.PrivateKeyDetails;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHCClient {
    private static final Logger logger = LoggerFactory.getLogger((String)"mainLogger");
    private static final int DEFAULT_SO_TIMEOUT = 5000;
    private static final RequestConfig DEFAULT_TRANSPORT_CONFIG = RequestConfig.custom().setCookieSpec("default").setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).build();
    private final HostnameVerifier allowAllHostnameVerifier = new HostnameVerifier(){

        @Override
        public boolean verify(String host, SSLSession session) {
            return true;
        }
    };

    public DHCResponse get(DHCConfig dhcConfig) throws DHCException {
        return this.get(dhcConfig, null, null);
    }

    public DHCResponse get(DHCConfig dhcConfig, ArrayList<NameValuePair> params, ArrayList<NameValuePair> headers) throws DHCException {
        HttpGet method = null;
        try {
            URIBuilder ub = new URIBuilder(dhcConfig.getUrl());
            if (null != params && !params.isEmpty()) {
                ub = ub.addParameters(this.toNameValuePair(params));
            }
            URI url = ub.build();
            method = new HttpGet(url);
        }
        catch (URISyntaxException ex) {
            throw new DHCConfigException(ex);
        }
        return this.send(dhcConfig, (HttpRequestBase)method, headers);
    }

    public DHCResponse post(DHCConfig dhcConfig, byte[] data, ArrayList<NameValuePair> headers) throws DHCException {
        HttpPost method = new HttpPost(dhcConfig.getUrl());
        method.setEntity((HttpEntity)new ByteArrayEntity(data));
        return this.send(dhcConfig, (HttpRequestBase)method, headers);
    }

    public DHCResponse postUrlEncoded(DHCConfig dhcConfig, ArrayList<NameValuePair> parts, ArrayList<NameValuePair> headers) throws DHCException {
        HttpPost method = new HttpPost(dhcConfig.getUrl());
        try {
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(this.toNameValuePair(parts));
            entity.setContentType(ContentType.APPLICATION_FORM_URLENCODED.getMimeType());
            method.setEntity((HttpEntity)entity);
        }
        catch (UnsupportedEncodingException uee) {
            return new DHCResponse(704, uee.getMessage());
        }
        return this.send(dhcConfig, (HttpRequestBase)method, headers);
    }

    public DHCResponse postMultipart(DHCConfig dhcConfig, ArrayList<NameValuePair> parts, ArrayList<NameValuePair> headers) throws DHCException {
        HttpPost method = new HttpPost(dhcConfig.getUrl());
        method.setEntity(this.getDataEntity(parts));
        return this.send(dhcConfig, (HttpRequestBase)method, headers);
    }

    public DHCResponse put(DHCConfig dhcConfig, byte[] data, ArrayList<NameValuePair> headers) throws DHCException {
        HttpPut method = new HttpPut(dhcConfig.getUrl());
        method.setEntity((HttpEntity)new ByteArrayEntity(data));
        return this.send(dhcConfig, (HttpRequestBase)method, headers);
    }

    public DHCResponse put(DHCConfig dhcConfig, ArrayList<NameValuePair> parts, ArrayList<NameValuePair> headers) throws DHCException {
        if (null == parts || parts.isEmpty()) {
            throw new DHCConfigException("Multipart items can not be null for Put method");
        }
        HttpPut method = new HttpPut(dhcConfig.getUrl());
        method.setEntity(this.getDataEntity(parts));
        return this.send(dhcConfig, (HttpRequestBase)method, headers);
    }

    public DHCResponse delete(DHCConfig dhcConfig, ArrayList<NameValuePair> headers) throws DHCException {
        HttpDelete method = new HttpDelete(dhcConfig.getUrl());
        return this.send(dhcConfig, (HttpRequestBase)method, headers);
    }

    public DHCResponse head(DHCConfig dhcConfig, ArrayList<NameValuePair> headers) throws DHCException {
        HttpHead method = new HttpHead(dhcConfig.getUrl());
        return this.send(dhcConfig, (HttpRequestBase)method, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DHCResponse send(DHCConfig dhcConfig, HttpRequestBase method, ArrayList<NameValuePair> headers) throws DHCException {
        if (null == dhcConfig) {
            throw new DHCConfigException("DHC Configuration cannot be null");
        }
        CloseableHttpClient client = null;
        try {
            DHCResponse response;
            method.setConfig(this.getTransportConfiguration(dhcConfig));
            if (null != headers && !headers.isEmpty()) {
                this.addHeaders(method, headers);
            }
            client = this.getHTTPClient(dhcConfig);
            if (dhcConfig.isHttpBasicAuthentication()) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(dhcConfig.getHttpBasicAuthUser(), dhcConfig.getHttpBasicAuthPass());
                try {
                    method.addHeader(new BasicScheme().authenticate((Credentials)credentials, (HttpRequest)method, null));
                }
                catch (AuthenticationException ae) {
                    throw new AssertionError((Object)ae);
                }
            }
            DHCResponse dHCResponse = response = this.getResponse((HttpUriRequest)method, client);
            return dHCResponse;
        }
        finally {
            if (null != method) {
                method.releaseConnection();
            }
            if (null != client) {
                try {
                    client.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private CloseableHttpClient getHTTPClient(DHCConfig dhcConfig) throws DHCException {
        HttpClientBuilder hcb = HttpClientBuilder.create();
        if (!dhcConfig.isContentCompression()) {
            hcb = hcb.disableContentCompression();
        }
        if (dhcConfig.isHttpsURL()) {
            hcb = hcb.setSSLSocketFactory((LayeredConnectionSocketFactory)this.getProtocolConfig(dhcConfig));
        }
        if (dhcConfig.isHttpBasicAuthentication()) {
            hcb = hcb.setDefaultCredentialsProvider(this.getCredentialsProvider(dhcConfig));
        }
        hcb = dhcConfig.followRedirects() ? hcb.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()) : hcb.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy());
        return hcb.build();
    }

    private RequestConfig getTransportConfiguration(DHCConfig dhcConfig) {
        RequestConfig.Builder builder = RequestConfig.copy((RequestConfig)DEFAULT_TRANSPORT_CONFIG);
        if (dhcConfig.isProxyTunneling()) {
            builder = builder.setProxy(this.getProxyConfig(dhcConfig));
        }
        builder = builder.setExpectContinueEnabled(dhcConfig.useExpectContinue());
        builder = builder.setSocketTimeout(dhcConfig.getSocketTimeout() > 0 ? dhcConfig.getSocketTimeout() : 5000);
        builder = builder.setConnectTimeout(dhcConfig.getConnectTimeout() > 0 ? dhcConfig.getConnectTimeout() : 5000);
        builder = builder.setConnectionRequestTimeout(dhcConfig.getReadTimeout() > 0 ? dhcConfig.getReadTimeout() : 5000);
        return builder.build();
    }

    private HttpHost getProxyConfig(DHCConfig dhcConfig) {
        if (dhcConfig.isProxyTunneling()) {
            logger.debug("Configure HTTP proxy (host={}, port={})", (Object)dhcConfig.getProxyHost(), (Object)dhcConfig.getProxyPort());
            return new HttpHost(dhcConfig.getProxyHost(), Integer.parseInt(dhcConfig.getProxyPort()));
        }
        return null;
    }

    private CredentialsProvider getCredentialsProvider(DHCConfig dhcConfig) {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        if (dhcConfig.isHttpBasicAuthentication()) {
            logger.debug("Configure HTTP authentication (user={})", (Object)dhcConfig.getHttpBasicAuthUser());
            UsernamePasswordCredentials usrPwdCredentials = new UsernamePasswordCredentials(dhcConfig.getHttpBasicAuthUser(), dhcConfig.getHttpBasicAuthPass());
            credsProvider.setCredentials(AuthScope.ANY, (Credentials)usrPwdCredentials);
        }
        return credsProvider;
    }

    private SSLConnectionSocketFactory getProtocolConfig(final DHCConfig dhcConfig) throws DHCException {
        SSLConnectionSocketFactory sslsf = null;
        if (dhcConfig.isHttpsURL()) {
            SSLContextBuilder builder = SSLContextBuilder.create();
            try {
                FileInputStream instream;
                if (null != dhcConfig.getTrustStorePath() && null != dhcConfig.getTrustStorePass() && null != dhcConfig.getTrustStoreType()) {
                    KeyStore trustStore = KeyStore.getInstance(dhcConfig.getTrustStoreType());
                    instream = new FileInputStream(new File(dhcConfig.getTrustStorePath()));
                    trustStore.load(instream, dhcConfig.getTrustStorePass().toCharArray());
                    builder = builder.loadTrustMaterial(trustStore, (TrustStrategy)new TrustSelfSignedStrategy());
                }
                if (null != dhcConfig.getKeyStorePath() && null != dhcConfig.getKeyStorePass() && null != dhcConfig.getKeyStoreType()) {
                    KeyStore keyStore = KeyStore.getInstance(dhcConfig.getKeyStoreType());
                    instream = new FileInputStream(new File(dhcConfig.getKeyStorePath()));
                    keyStore.load(instream, dhcConfig.getKeyStorePass().toCharArray());
                    if (dhcConfig.hasKeyStoreAlias()) {
                        builder.loadKeyMaterial(keyStore, dhcConfig.getKeyStorePass().toCharArray(), new PrivateKeyStrategy(){

                            public String chooseAlias(Map<String, PrivateKeyDetails> map, Socket socket) {
                                return dhcConfig.getKeyStoreAlias();
                            }
                        });
                    } else {
                        builder = builder.loadKeyMaterial(keyStore, dhcConfig.getKeyStorePass().toCharArray());
                    }
                }
                sslsf = new SSLConnectionSocketFactory(builder.build(), dhcConfig.getSupportedProtocolsArray(), dhcConfig.getSupportedCiphersArray(), this.allowAllHostnameVerifier);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
                throw new DHCCredentialException(ex);
            }
            catch (IOException ioe) {
                throw new DHCConfigException(ioe);
            }
        }
        return sslsf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DHCResponse getResponse(HttpUriRequest method, CloseableHttpClient httpClient) {
        DHCResponse response = null;
        CloseableHttpResponse hresponse = null;
        try {
            logger.debug("Request method={} uri={}", (Object)method.getMethod(), (Object)method.getURI().toString());
            hresponse = httpClient.execute(method);
            int statusCode = hresponse.getStatusLine().getStatusCode();
            HttpEntity resEntity = hresponse.getEntity();
            byte[] resultContent = null;
            ArrayList<NameValuePair> responseHeaders = null;
            if (null != resEntity) {
                resultContent = EntityUtils.toByteArray((HttpEntity)resEntity);
            }
            if (null != hresponse.getAllHeaders()) {
                responseHeaders = new ArrayList<NameValuePair>();
                for (Header header : hresponse.getAllHeaders()) {
                    responseHeaders.add(new NameValuePair(header.getName(), header.getValue()));
                }
            }
            response = new DHCResponse(statusCode, responseHeaders, resultContent);
        }
        catch (UnknownHostException uhe) {
            response = new DHCResponse(702, uhe.getMessage());
        }
        catch (SocketTimeoutException ste) {
            response = new DHCResponse(601, ste.getMessage());
        }
        catch (ConnectTimeoutException cte) {
            response = new DHCResponse(601, cte.getMessage());
        }
        catch (SSLException se) {
            response = new DHCResponse(602, se.getMessage());
        }
        catch (ClientProtocolException cpe) {
            response = new DHCResponse(701, cpe.getMessage());
            logger.info("", (Throwable)cpe);
            cpe.printStackTrace();
        }
        catch (IOException ioe) {
            response = new DHCResponse(600, ioe.getMessage());
        }
        finally {
            if (null != hresponse) {
                try {
                    hresponse.close();
                }
                catch (IOException uhe) {}
            }
        }
        return response;
    }

    private void addHeaders(HttpRequestBase method, ArrayList<NameValuePair> headers) {
        if (null != headers) {
            headers.stream().forEach(header -> {
                if (!header.isObject()) {
                    method.addHeader(header.getName(), header.getStringValue());
                } else {
                    method.addHeader(header.getName(), String.valueOf(header.getObjectValue()));
                }
            });
        }
    }

    private List<org.apache.http.NameValuePair> toNameValuePair(ArrayList<NameValuePair> parts) {
        ArrayList<org.apache.http.NameValuePair> nameValuePairs = new ArrayList<org.apache.http.NameValuePair>();
        if (null != parts) {
            parts.stream().forEach(part -> {
                if (!part.isObject()) {
                    nameValuePairs.add((org.apache.http.NameValuePair)new BasicNameValuePair(part.getName(), part.getStringValue()));
                } else {
                    nameValuePairs.add((org.apache.http.NameValuePair)new BasicNameValuePair(part.getName(), String.valueOf(part.getObjectValue())));
                }
            });
        }
        return nameValuePairs;
    }

    private HttpEntity getDataEntity(ArrayList<NameValuePair> parts) {
        MultipartEntityBuilder mpBuilder = MultipartEntityBuilder.create();
        mpBuilder.setMode(HttpMultipartMode.RFC6532);
        mpBuilder.setBoundary("" + System.nanoTime());
        if (null != parts) {
            parts.stream().forEach(part -> {
                ContentType contentType;
                try {
                    contentType = ContentType.parse((String)part.getContentType());
                }
                catch (Exception e) {
                    contentType = ContentType.TEXT_PLAIN;
                }
                String charEncoding = part.getCharEncoding();
                if (null != charEncoding) {
                    contentType = contentType.withCharset(charEncoding);
                }
                if (!part.isObject()) {
                    StringBody body = new StringBody(part.getStringValue(), contentType);
                    mpBuilder.addPart(part.getName(), (ContentBody)body);
                } else {
                    mpBuilder.addBinaryBody(part.getName(), (byte[])part.getObjectValue(), contentType, part.getName());
                }
            });
        }
        return mpBuilder.build();
    }
}

