/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.keyutil.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import no.bbs.tt.keyutil.exception.InvalidConfigException;

public final class PropertyUtil {
    private PropertyUtil() {
    }

    public static String getRequiredProperty(Properties properties, String property) throws IllegalArgumentException, InvalidConfigException {
        if (properties == null) {
            throw new IllegalArgumentException("properties can not be null");
        }
        if (property == null || property.equals("")) {
            throw new IllegalArgumentException("property can not be null or empty");
        }
        String propertyValue = properties.getProperty(property);
        if (propertyValue == null || propertyValue.equals("")) {
            throw new InvalidConfigException("Property " + property + " must be set");
        }
        return propertyValue;
    }

    public static void testForRequiredProperties(List<String> requiredProperties, Properties properties) throws InvalidConfigException {
        ArrayList<String> propertiesNotPresent = new ArrayList<String>();
        for (String property : requiredProperties) {
            String p = properties.getProperty(property);
            if (p != null && !p.equals("")) continue;
            propertiesNotPresent.add(property);
        }
        if (!propertiesNotPresent.isEmpty()) {
            String errorMessage = "The following properties are missing or contains empty values: ";
            for (int i = 0; i < propertiesNotPresent.size(); ++i) {
                errorMessage = errorMessage + (String)propertiesNotPresent.get(i);
                if (i == propertiesNotPresent.size() - 1) continue;
                errorMessage = errorMessage + ", ";
            }
            throw new InvalidConfigException(errorMessage);
        }
    }

    public static void logProperties(Properties properties) {
        Properties tmpProperties = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.equalsIgnoreCase("pw")) {
                tmpProperties.setProperty(key, "*******");
                continue;
            }
            tmpProperties.setProperty(key, value);
        }
    }
}

