/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream;

import com.sun.org.apache.xerces.internal.impl.PropertyManager;
import com.sun.xml.internal.stream.writers.XMLDOMWriterImpl;
import com.sun.xml.internal.stream.writers.XMLEventWriterImpl;
import com.sun.xml.internal.stream.writers.XMLStreamWriterImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stream.StreamResult;

public class XMLOutputFactoryImpl
extends XMLOutputFactory {
    private PropertyManager fPropertyManager = new PropertyManager(2);
    private XMLStreamWriterImpl fStreamWriter = null;
    private StreamResult fStreamResult = new StreamResult();
    boolean fReuseInstance = false;
    private static final boolean DEBUG = false;
    private boolean fPropertyChanged;

    public XMLEventWriter createXMLEventWriter(OutputStream outputStream) throws XMLStreamException {
        return this.createXMLEventWriter(outputStream, null);
    }

    public XMLEventWriter createXMLEventWriter(OutputStream outputStream, String encoding) throws XMLStreamException {
        return new XMLEventWriterImpl(this.createXMLStreamWriter(outputStream, encoding));
    }

    public XMLEventWriter createXMLEventWriter(Result result) throws XMLStreamException {
        if (result instanceof StAXResult && ((StAXResult)result).getXMLEventWriter() != null) {
            return ((StAXResult)result).getXMLEventWriter();
        }
        return new XMLEventWriterImpl(this.createXMLStreamWriter(result));
    }

    public XMLEventWriter createXMLEventWriter(Writer writer) throws XMLStreamException {
        return new XMLEventWriterImpl(this.createXMLStreamWriter(writer));
    }

    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {
        if (result instanceof StreamResult) {
            return this.createXMLStreamWriter((StreamResult)result, null);
        }
        if (result instanceof DOMResult) {
            return new XMLDOMWriterImpl((DOMResult)result);
        }
        if (result instanceof StAXResult) {
            if (((StAXResult)result).getXMLStreamWriter() != null) {
                return ((StAXResult)result).getXMLStreamWriter();
            }
        } else if (result instanceof Result) {
            return this.createXMLStreamWriter(new StreamResult(result.getSystemId()));
        }
        throw new UnsupportedOperationException("result of type " + result + " is not supported");
    }

    public XMLStreamWriter createXMLStreamWriter(Writer writer) throws XMLStreamException {
        return this.createXMLStreamWriter(this.getStreamResult(null, writer, null), null);
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream) throws XMLStreamException {
        return this.createXMLStreamWriter(outputStream, null);
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream, String encoding) throws XMLStreamException {
        return this.createXMLStreamWriter(this.getStreamResult(outputStream, null, null), encoding);
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Property not supported");
        }
        if (this.fPropertyManager.containsProperty(name)) {
            return this.fPropertyManager.getProperty(name);
        }
        throw new IllegalArgumentException("Property not supported");
    }

    public boolean isPropertySupported(String name) {
        if (name == null) {
            return false;
        }
        return this.fPropertyManager.containsProperty(name);
    }

    public void setProperty(String name, Object value) throws IllegalArgumentException {
        if (name == null || value == null || !this.fPropertyManager.containsProperty(name)) {
            throw new IllegalArgumentException("Property " + name + "is not supported");
        }
        if (name == "reuse-instance" || name.equals("reuse-instance")) {
            this.fReuseInstance = (Boolean)value;
            if (this.fReuseInstance) {
                throw new IllegalArgumentException("Property " + name + " is not supported: XMLStreamWriters are not Thread safe");
            }
        } else {
            this.fPropertyChanged = true;
        }
        this.fPropertyManager.setProperty(name, value);
    }

    PropertyManager getPropertyManager() {
        return this.fPropertyChanged ? this.fPropertyManager : null;
    }

    StreamResult getStreamResult(OutputStream os, Writer writer, String systemId) {
        this.fStreamResult.setOutputStream(os);
        this.fStreamResult.setWriter(writer);
        this.fStreamResult.setSystemId(systemId);
        return this.fStreamResult;
    }

    XMLStreamWriter createXMLStreamWriter(StreamResult sr, String encoding) throws XMLStreamException {
        try {
            if (this.fReuseInstance && this.fStreamWriter != null && this.fStreamWriter.canReuse() && !this.fPropertyChanged) {
                this.fStreamWriter.reset();
                this.fStreamWriter.setOutput(sr, encoding);
                return this.fStreamWriter;
            }
            this.fStreamWriter = new XMLStreamWriterImpl(sr, encoding, this.getPropertyManager());
            return this.fStreamWriter;
        }
        catch (IOException io) {
            throw new XMLStreamException(io);
        }
    }
}

