/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.trust.esignclientapi.impl;

import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import no.bbs.trust.esignclientapi.comm.DHCHTTPClient;
import no.bbs.trust.esignclientapi.comm.DHCHTTPResponse;
import no.bbs.trust.esignclientapi.ds.XMLSigner;
import no.bbs.trust.esignclientapi.errorhandler.ESignXmlErrorHandler;
import no.bbs.trust.esignclientapi.exception.ESignClientException;
import no.bbs.trust.esignclientapi.impl.MerchantContext;
import no.bbs.trust.esignclientapi.statics.ESignError;
import no.bbs.trust.esignclientapi.statics.ESignNamespace;
import no.bbs.trust.esignclientapi.util.FileUtil;
import no.bbs.trust.esignclientapi.util.String2Document;
import no.bbs.trust.esignclientapi.util.XML2String;
import no.bbs.tt.trustsign.tsm.xml.messages.AddEndUserSignatureRequest;
import no.bbs.tt.trustsign.tsm.xml.messages.AddEndUserSignatureResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.BaseRequestMessage;
import no.bbs.tt.trustsign.tsm.xml.messages.CancelOrderRequest;
import no.bbs.tt.trustsign.tsm.xml.messages.CancelOrderResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.DeleteDocumentDataRequest;
import no.bbs.tt.trustsign.tsm.xml.messages.DeleteDocumentDataResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.ErrorResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.FinalizeOrderRequest;
import no.bbs.tt.trustsign.tsm.xml.messages.FinalizeOrderResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.GeneratePAdESRequest;
import no.bbs.tt.trustsign.tsm.xml.messages.GeneratePAdESResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.GetDocumentsRequest;
import no.bbs.tt.trustsign.tsm.xml.messages.GetDocumentsResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.GetNotificationLogRequest;
import no.bbs.tt.trustsign.tsm.xml.messages.GetNotificationLogResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.GetOrderDetailsRequest;
import no.bbs.tt.trustsign.tsm.xml.messages.GetOrderDetailsResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.GetOrderRequest;
import no.bbs.tt.trustsign.tsm.xml.messages.GetOrderResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.GetOrderStatusRequest;
import no.bbs.tt.trustsign.tsm.xml.messages.GetOrderStatusResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.GetOrdersRequest;
import no.bbs.tt.trustsign.tsm.xml.messages.GetOrdersResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.GetPAdESRequest;
import no.bbs.tt.trustsign.tsm.xml.messages.GetPAdESResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.GetSDODetailsRequest;
import no.bbs.tt.trustsign.tsm.xml.messages.GetSDODetailsResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.GetSDORequest;
import no.bbs.tt.trustsign.tsm.xml.messages.GetSDOResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.GetSignatureRequest;
import no.bbs.tt.trustsign.tsm.xml.messages.GetSignatureResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.GetSigningProcessesRequest;
import no.bbs.tt.trustsign.tsm.xml.messages.GetSigningProcessesResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.InsertOrderRequest;
import no.bbs.tt.trustsign.tsm.xml.messages.InsertOrderResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.MerchantSignDocumentRequest;
import no.bbs.tt.trustsign.tsm.xml.messages.MerchantSignDocumentResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.MergeSDOsRequest;
import no.bbs.tt.trustsign.tsm.xml.messages.MergeSDOsResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.ModifyOrderDeadlineRequest;
import no.bbs.tt.trustsign.tsm.xml.messages.ModifyOrderDeadlineResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.ModifySignerRequest;
import no.bbs.tt.trustsign.tsm.xml.messages.ModifySignerResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.ModifySigningProcessRequest;
import no.bbs.tt.trustsign.tsm.xml.messages.ModifySigningProcessResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.TrustSignMessage;
import no.bbs.tt.trustsign.tsm.xml.messages.ValidateSDORequest;
import no.bbs.tt.trustsign.tsm.xml.messages.ValidateSDOResponse;
import no.bbs.tt.trustsign.tsm.xml.util.SecureDocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ESigningFacade {
    private MerchantContext context = null;

    protected ESigningFacade(MerchantContext ctx) {
        this.context = ctx;
    }

    public void setNamespace(TrustSignMessage request) {
        if (null == request.getNamespace()) {
            request.setNamespace("http://www.bbs.no/tt/trustsign/2024/04/tsm#");
            request.setNamespace(ESignNamespace.ESIGN_MOST_RECENT.getNamespace());
        }
    }

    public InsertOrderResponse insertOrder(InsertOrderRequest request) throws ESignClientException {
        String signedXml = this.validateAndParseRequest(request);
        Document responseDoc = this.executeESignRequest(signedXml);
        return new InsertOrderResponse(responseDoc);
    }

    public CancelOrderResponse cancelOrder(CancelOrderRequest request) throws ESignClientException {
        String signedXml = this.validateAndParseRequest(request);
        Document responseDoc = this.executeESignRequest(signedXml);
        return new CancelOrderResponse(responseDoc);
    }

    public GetDocumentsResponse getDocuments(GetDocumentsRequest request) throws ESignClientException {
        String signedXml = this.validateAndParseRequest(request);
        Document responseDoc = this.executeESignRequest(signedXml);
        return new GetDocumentsResponse(responseDoc);
    }

    public GetNotificationLogResponse getNotificationLog(GetNotificationLogRequest request) throws ESignClientException {
        String signedXml = this.validateAndParseRequest(request);
        Document responseDoc = this.executeESignRequest(signedXml);
        return new GetNotificationLogResponse(responseDoc);
    }

    public GetOrderResponse getOrder(GetOrderRequest request) throws ESignClientException {
        String signedXml = this.validateAndParseRequest(request);
        Document responseDoc = this.executeESignRequest(signedXml);
        return new GetOrderResponse(responseDoc);
    }

    public GetOrderDetailsResponse getOrderDetails(GetOrderDetailsRequest request) throws ESignClientException {
        String signedXml = this.validateAndParseRequest(request);
        Document responseDoc = this.executeESignRequest(signedXml);
        return new GetOrderDetailsResponse(responseDoc);
    }

    public GetOrdersResponse getOrders(GetOrdersRequest request) throws ESignClientException {
        String signedXml = this.validateAndParseRequest(request);
        Document responseDoc = this.executeESignRequest(signedXml);
        return new GetOrdersResponse(responseDoc);
    }

    public GetOrderStatusResponse getOrderStatus(GetOrderStatusRequest request) throws ESignClientException {
        String signedXml = this.validateAndParseRequest(request);
        Document responseDoc = this.executeESignRequest(signedXml);
        return new GetOrderStatusResponse(responseDoc);
    }

    public GetSDOResponse getSDO(GetSDORequest request) throws ESignClientException {
        String signedXml = this.validateAndParseRequest(request);
        Document responseDoc = this.executeESignRequest(signedXml);
        return new GetSDOResponse(responseDoc);
    }

    public GetSDODetailsResponse getSDODetails(GetSDODetailsRequest request) throws ESignClientException {
        String signedXml = this.validateAndParseRequest(request);
        Document responseDoc = this.executeESignRequest(signedXml);
        return new GetSDODetailsResponse(responseDoc);
    }

    public GetSigningProcessesResponse getSigningProcesses(GetSigningProcessesRequest request) throws ESignClientException {
        String signedXml = this.validateAndParseRequest(request);
        Document responseDoc = this.executeESignRequest(signedXml);
        return new GetSigningProcessesResponse(responseDoc);
    }

    public MergeSDOsResponse mergeSDOs(MergeSDOsRequest request) throws ESignClientException {
        String signedXml = this.validateAndParseRequest(request);
        Document responseDoc = this.executeESignRequest(signedXml);
        return new MergeSDOsResponse(responseDoc);
    }

    public ModifyOrderDeadlineResponse modifyOrderDeadline(ModifyOrderDeadlineRequest request) throws ESignClientException {
        String signedXml = this.validateAndParseRequest(request);
        Document responseDoc = this.executeESignRequest(signedXml);
        return new ModifyOrderDeadlineResponse(responseDoc);
    }

    public ModifySigningProcessResponse modifySigningProcess(ModifySigningProcessRequest request) throws ESignClientException {
        String signedXml = this.validateAndParseRequest(request);
        Document responseDoc = this.executeESignRequest(signedXml);
        return new ModifySigningProcessResponse(responseDoc);
    }

    public GetPAdESResponse getPAdES(GetPAdESRequest request) throws ESignClientException {
        String signedXml = this.validateAndParseRequest(request);
        Document responseDoc = this.executeESignRequest(signedXml);
        return new GetPAdESResponse(responseDoc);
    }

    public GeneratePAdESResponse generatePAdES(GeneratePAdESRequest request) throws ESignClientException {
        String signedXml = this.validateAndParseRequest(request);
        Document responseDoc = this.executeESignRequest(signedXml);
        return new GeneratePAdESResponse(responseDoc);
    }

    public ValidateSDOResponse validateSDO(ValidateSDORequest request) throws ESignClientException {
        String signedXml = this.validateAndParseRequest(request);
        Document responseDoc = this.executeESignRequest(signedXml);
        return new ValidateSDOResponse(responseDoc);
    }

    public DeleteDocumentDataResponse deleteDocumentdata(DeleteDocumentDataRequest request) throws ESignClientException {
        String signedXml = this.validateAndParseRequest(request);
        Document responseDoc = this.executeESignRequest(signedXml);
        return new DeleteDocumentDataResponse(responseDoc);
    }

    public FinalizeOrderResponse finalizeOrder(FinalizeOrderRequest request) throws ESignClientException {
        String signedXml = this.validateAndParseRequest(request);
        Document responseDoc = this.executeESignRequest(signedXml);
        return new FinalizeOrderResponse(responseDoc);
    }

    public ModifySignerResponse modifySigner(ModifySignerRequest request) throws ESignClientException {
        String signedXml = this.validateAndParseRequest(request);
        Document responseDoc = this.executeESignRequest(signedXml);
        return new ModifySignerResponse(responseDoc);
    }

    public GetSignatureResponse getSignature(GetSignatureRequest request) throws ESignClientException {
        String signedXml = this.validateAndParseRequest(request);
        Document responseDoc = this.executeESignRequest(signedXml);
        return new GetSignatureResponse(responseDoc);
    }

    public MerchantSignDocumentResponse merchantSignDocument(MerchantSignDocumentRequest request) throws ESignClientException {
        String signedXml = this.validateAndParseRequest(request);
        Document responseDoc = this.executeESignRequest(signedXml);
        return new MerchantSignDocumentResponse(responseDoc);
    }

    public AddEndUserSignatureResponse addEndUserSignature(AddEndUserSignatureRequest request) throws ESignClientException {
        String signedXml = this.validateAndParseRequest(request);
        Document responseDoc = this.executeESignRequest(signedXml);
        return new AddEndUserSignatureResponse(responseDoc);
    }

    private String validateAndParseRequest(BaseRequestMessage request) throws ESignClientException {
        String signedXml;
        String xmlRequest;
        if (null == request) {
            throw this.getESignClientException("Input Request cannot be null");
        }
        String type = request.getType();
        this.setNamespace(request);
        try {
            xmlRequest = XML2String.document2String(request.toXML());
        }
        catch (Exception e) {
            throw this.getESignClientException("Failed to get XML from input " + type + ". " + e.getMessage());
        }
        try {
            this.verifyXML(xmlRequest);
        }
        catch (Exception e) {
            throw this.getESignClientException("Failed to verify " + type + " xml representation. " + e.getMessage());
        }
        try {
            XMLSigner signer = new XMLSigner(this.context.getSigningPKCS12Keystore());
            signedXml = signer.signXML(xmlRequest);
        }
        catch (Exception e) {
            throw this.getESignClientException("Failed to sign " + type + " XML. " + e.getMessage());
        }
        return signedXml;
    }

    private Document executeESignRequest(String signedXml) throws ESignClientException {
        Document responseDoc;
        String responseXml;
        try {
            DHCHTTPClient communicator = new DHCHTTPClient();
            DHCHTTPResponse response = communicator.post(this.context.getDhcConfig(), signedXml.getBytes(StandardCharsets.UTF_8), null);
            if (response.getStatus() > 200) {
                throw this.getESignClientException("Failed to communicate to [" + this.context.getEnv().getUrl() + "] Error returned: " + response.getContent() + " - " + response.getStatus() + " - " + response.getStatusText());
            }
            responseXml = response.getContent();
        }
        catch (Throwable t) {
            if (t instanceof ESignClientException) {
                throw t;
            }
            throw this.getESignClientException("An unexpected error occurred communicating with the ESign infrastructure: " + t.getMessage());
        }
        try {
            responseDoc = this.verifyXML(responseXml);
        }
        catch (Throwable t) {
            throw this.getESignClientException("Failed to verify response xml. " + t.getMessage());
        }
        this.validateIfErrorResponse(responseDoc);
        return responseDoc;
    }

    private Document verifyXML(String xml) throws Exception {
        String2Document s2d = new String2Document();
        Document responseDoc = s2d.createDocumentFromString(xml);
        String xmlns = responseDoc.getDocumentElement().getAttribute("xmlns");
        ESignNamespace ns = ESignNamespace.getByNS(xmlns);
        if (null == ns) {
            throw new Exception("Invalid TrustSignMessage or RMSMessage. XML did no verify. Xml namespace (" + (Object)((Object)ns) + ") is not supported");
        }
        String schemaFile = ns.getXsd();
        InputStream is = FileUtil.getResourceFromStream(schemaFile);
        if (null == is) {
            throw new Exception("Invalid TrustSignMessage or RMSMessage. XML did no verify. Xsd (" + schemaFile + ") is not in classpath");
        }
        DocumentBuilderFactory dbf = SecureDocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(true);
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", is);
        DocumentBuilder docBuidler = dbf.newDocumentBuilder();
        docBuidler.setErrorHandler(new ESignXmlErrorHandler());
        docBuidler.parse(new InputSource(new StringReader(xml)));
        return responseDoc;
    }

    protected void validateIfErrorResponse(Document responseDoc) throws ESignClientException {
        Element root = (Element)responseDoc.getFirstChild();
        NodeList nl = root.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            String nn;
            if (nl.item(i).getNodeType() != 1 || !(nn = nl.item(i).getNodeName()).startsWith("Error")) continue;
            ErrorResponse errorresponse = new ErrorResponse(responseDoc);
            String errorcode = errorresponse.getErrorCode();
            String errorText = errorresponse.getErrorText();
            String orderid = errorresponse.getOrderID();
            String transid = errorresponse.getTransRef();
            ArrayList<String> errParams = new ArrayList<String>();
            errParams.add("ESign returned an error response. OrderId [" + orderid + "] TransId [" + transid + "] ESignService(TSOS) ErrorCode [" + errorcode + "] ErrorText [" + errorText + "]");
            throw new ESignClientException(ESignError.ESIGNFACADE_REQUEST_FAILED, Integer.parseInt(errorcode), errParams);
        }
    }

    private ESignClientException getESignClientException(String message) {
        ArrayList<String> errParams = new ArrayList<String>();
        errParams.add(message);
        return new ESignClientException(ESignError.ESIGNFACADE_REQUEST_FAILED, errParams);
    }
}

