/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.messages.containers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.SigningProcess;
import no.bbs.tt.trustsign.tsm.xml.util.DateUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Step
implements Comparable<Object>,
Serializable {
    private static final long serialVersionUID = 1753910873977742725L;
    private int stepNumber = -1;
    private Date stepDeadline = null;
    private ArrayList<SigningProcess> signingProcesses = null;
    private String stepStatus = null;

    public Step() {
    }

    public Step(Element element) {
        NodeList nl = element.getElementsByTagName("StepNumber");
        if (nl.getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setStepNumber(Integer.parseInt(nl.item(0).getFirstChild().getNodeValue()));
        }
        if ((nl = element.getElementsByTagName("StepDeadline")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setStepDeadline(DateUtility.XMLToDate(nl.item(0).getFirstChild().getNodeValue()));
        }
        if ((nl = element.getElementsByTagName("SigningProcess")).getLength() > 0) {
            this.signingProcesses = new ArrayList();
            for (int i = 0; i < nl.getLength(); ++i) {
                Element currSP = (Element)nl.item(i);
                this.signingProcesses.add(new SigningProcess(currSP));
            }
        }
        if ((nl = element.getElementsByTagName("StepStatus")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setStepStatus(nl.item(0).getFirstChild().getNodeValue());
        }
    }

    public Element toXML(Document doc) {
        Element childElement;
        Element root = doc.createElement("Step");
        Element stepNumberElem = doc.createElement("StepNumber");
        stepNumberElem.appendChild(doc.createTextNode("" + this.getStepNumber()));
        root.appendChild(stepNumberElem);
        if (null != this.getStepStatus()) {
            childElement = doc.createElement("StepStatus");
            childElement.appendChild(doc.createTextNode(this.getStepStatus()));
            root.appendChild(childElement);
        }
        if (null != this.getStepDeadline()) {
            childElement = doc.createElement("StepDeadline");
            childElement.appendChild(doc.createTextNode(DateUtility.DateToXML(this.getStepDeadline())));
            root.appendChild(childElement);
        }
        if (null != this.getSigningProcesses() && !this.getSigningProcesses().isEmpty()) {
            for (int i = 0; i < this.getSigningProcesses().size(); ++i) {
                SigningProcess curSP = this.getSigningProcesses().get(i);
                root.appendChild(curSP.toXML(doc));
            }
        }
        if (null != this.getStepStatus()) {
            Element childElement2 = doc.createElement("StepStatus");
            childElement2.appendChild(doc.createTextNode(this.getStepStatus()));
            root.appendChild(childElement2);
        }
        doc.getFirstChild().appendChild(root);
        return root;
    }

    public String getStepStatus() {
        return this.stepStatus;
    }

    public void setStepStatus(String stepStatus) {
        this.stepStatus = stepStatus;
    }

    public int getStepNumber() {
        return this.stepNumber;
    }

    public void setStepNumber(int stepNumber) {
        this.stepNumber = stepNumber;
    }

    public Date getStepDeadline() {
        return this.stepDeadline;
    }

    public void setStepDeadline(Date stepDeadline) {
        this.stepDeadline = stepDeadline;
    }

    public ArrayList<SigningProcess> getSigningProcesses() {
        return this.signingProcesses;
    }

    public void setSigningProcesses(ArrayList<SigningProcess> signingProcesses) {
        this.signingProcesses = signingProcesses;
    }

    public void addSigningProcess(SigningProcess sp) {
        if (null == this.signingProcesses) {
            this.signingProcesses = new ArrayList();
        }
        this.signingProcesses.add(sp);
    }

    @Override
    public int compareTo(Object o) {
        Step toCompareTo = (Step)o;
        if (this.getStepNumber() > toCompareTo.getStepNumber()) {
            return 1;
        }
        if (this.getStepNumber() < toCompareTo.getStepNumber()) {
            return -1;
        }
        return 0;
    }
}

