/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.keyutil;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import no.bbs.tt.keyutil.exception.InvalidConfigException;

public final class CommandLineParser {
    private Properties properties;
    private static final String MODE_KEYGEN = "keygen";
    private static final String MODE_IMPORT = "import";
    private Mode mode;

    public CommandLineParser(String[] args) {
        if (args.length < 1) {
            throw new InvalidConfigException("No mode specified");
        }
        String modeString = args[0];
        if (modeString.equals(MODE_KEYGEN)) {
            this.mode = Mode.KEYGEN;
        } else if (modeString.equals(MODE_IMPORT)) {
            this.mode = Mode.IMPORT;
        } else {
            throw new InvalidConfigException("Unknown mode: " + modeString);
        }
        this.properties = new Properties();
        List<String> argsList = Arrays.asList(args);
        Iterator<String> iterator = argsList.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            String[] quoteCharacters;
            String arg = iterator.next();
            if (!arg.startsWith("-")) {
                throw new InvalidConfigException("Invalid argument '" + arg + "'. Command line arguments must start with '-'");
            }
            String property = arg.substring(1);
            if (!iterator.hasNext()) {
                throw new InvalidConfigException("No value for command line argument " + arg);
            }
            String value = iterator.next();
            for (String quoteCharacter : quoteCharacters = new String[]{"\"", "'"}) {
                if (!value.startsWith(quoteCharacter)) continue;
                String realValue = value.substring(1);
                while (!realValue.contains(quoteCharacter)) {
                    if (!iterator.hasNext()) {
                        throw new InvalidConfigException("No closing quote on command line");
                    }
                    realValue = realValue + " " + iterator.next();
                }
                if (!realValue.endsWith(quoteCharacter)) {
                    throw new InvalidConfigException("Argument must end with a quote: " + realValue);
                }
                value = realValue = realValue.substring(0, realValue.length() - 1);
            }
            this.properties.setProperty(property, value);
        }
    }

    public static void printUsage(PrintStream out) {
        out.append("Usage:\n");
        out.append("keyutil keygen [-dn <distinguished name>] -pw <key password> -keysize <key size> -keyfile <file name> -p10file <file name>\n");
        out.append("keyutil import -pw <key password> -keyfile <file name> -certfile <certificate file> -p12file <pkcs12 file>\n");
        out.flush();
    }

    public Mode getMode() {
        return this.mode;
    }

    public Properties getProperties() {
        return this.properties;
    }

    static enum Mode {
        KEYGEN,
        IMPORT;

    }
}

