/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.keyutil;

import java.io.File;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import java.util.Properties;
import no.bbs.tt.keyutil.CommandLineParser;
import no.bbs.tt.keyutil.KeyUtilProperty;
import no.bbs.tt.keyutil.exception.InvalidConfigException;
import no.bbs.tt.keyutil.exception.KeyUtilException;
import no.bbs.tt.keyutil.labours.SoftCertificateImporter;
import no.bbs.tt.keyutil.labours.SoftKeyGenerator;
import no.bbs.tt.keyutil.util.FormatUtil;
import no.bbs.tt.keyutil.util.PropertyUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class KeyUtil {
    private static final int EXIT_ERROR = 1;

    public static void main(String[] args) {
        try {
            new KeyUtil(args);
        }
        catch (InvalidConfigException e) {
            System.out.println(e.getMessage());
            CommandLineParser.printUsage(System.out);
            System.exit(1);
        }
        catch (KeyUtilException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
    }

    private KeyUtil(String[] args) {
        Properties properties = new Properties();
        CommandLineParser commandLineParser = new CommandLineParser(args);
        Properties commandLineProperties = commandLineParser.getProperties();
        properties.putAll((Map<?, ?>)commandLineProperties);
        PropertyUtil.logProperties(properties);
        CommandLineParser.Mode mode = commandLineParser.getMode();
        if (mode.equals((Object)CommandLineParser.Mode.KEYGEN)) {
            PropertyUtil.testForRequiredProperties(KeyUtilProperty.REQUIRED_PROPERTIES_KEYGEN, properties);
            int keysize = FormatUtil.parseInt(properties.getProperty("keysize"));
            String pw = properties.getProperty("pw");
            File p10OutputFile = new File(properties.getProperty("p10file"));
            File keyFile = new File(properties.getProperty("keyfile"));
            String dn = properties.getProperty("dn", "");
            SoftKeyGenerator keyGenerator = new SoftKeyGenerator();
            keyGenerator.generateKeyPairAndCreateP10(p10OutputFile, keyFile, pw, keysize, dn);
        } else if (mode.equals((Object)CommandLineParser.Mode.IMPORT)) {
            PropertyUtil.testForRequiredProperties(KeyUtilProperty.REQUIRED_PROPERTIES_IMPORT, properties);
            String password = properties.getProperty("pw");
            String certFile = properties.getProperty("certfile");
            String p12File = properties.getProperty("p12file");
            String keyFile = properties.getProperty("keyfile");
            SoftCertificateImporter certificateImporter = new SoftCertificateImporter();
            certificateImporter.importCertificate(new File(certFile), new File(keyFile), new File(p12File), password);
        } else {
            throw new InvalidConfigException("Unknown mode: " + (Object)((Object)mode));
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

