/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.keyutil.labours;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPublicKey;
import java.util.Enumeration;
import java.util.List;
import no.bbs.tt.keyutil.exception.KeyUtilException;
import no.bbs.tt.keyutil.labours.CertificateImporter;
import no.bbs.tt.keyutil.util.CertificateUtil;
import no.bbs.tt.keyutil.util.FileUtil;
import no.bbs.tt.keyutil.util.FormatUtil;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;

public class SoftCertificateImporter
implements CertificateImporter {
    @Override
    public void importCertificate(File certFile, File keyFile, File p12File, String pw) {
        FileOutputStream fos;
        Enumeration<String> aliases;
        FileInputStream fis;
        byte[] certBytes = null;
        try {
            certBytes = FileUtil.readFileAsBytes(certFile);
        }
        catch (IOException e) {
            throw new KeyUtilException("Unable to read file: " + e.getMessage(), e);
        }
        List<Certificate> certificates = null;
        try {
            certificates = CertificateUtil.getCertificatesFromBytes(certBytes);
        }
        catch (IllegalArgumentException e) {
            throw new KeyUtilException("Unable to parse certificate: " + e.getMessage(), e);
        }
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("PKCS12", "BC");
        }
        catch (NoSuchProviderException nspe) {
            throw new KeyUtilException("Provider not present: ", nspe);
        }
        catch (KeyStoreException kse) {
            throw new KeyUtilException("Unable to create keystore: ", kse);
        }
        try {
            fis = new FileInputStream(keyFile);
        }
        catch (FileNotFoundException fnfe) {
            throw new KeyUtilException("Unable to find file " + keyFile.getAbsolutePath(), fnfe);
        }
        try {
            keyStore.load(fis, pw.toCharArray());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KeyUtilException(nsae);
        }
        catch (CertificateException ce) {
            throw new KeyUtilException(ce);
        }
        catch (IOException ie) {
            throw new KeyUtilException(ie);
        }
        finally {
            if (fis != null) {
                try {
                    ((InputStream)fis).close();
                }
                catch (IOException ioe) {
                    throw new KeyUtilException("Unable to close keystore file " + keyFile.getAbsolutePath(), ioe);
                }
            }
        }
        String pubKeyDigestString = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1", "BC");
            RSAPublicKey k = (RSAPublicKey)certificates.get(0).getPublicKey();
            byte[] pubKeyDigest = md.digest(k.getModulus().toByteArray());
            pubKeyDigestString = FormatUtil.toHexString(pubKeyDigest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyUtilException(e);
        }
        catch (NoSuchProviderException nspe) {
            throw new KeyUtilException("Provider not present: ", nspe);
        }
        try {
            aliases = keyStore.aliases();
        }
        catch (KeyStoreException kse) {
            throw new KeyUtilException(kse);
        }
        String alias = null;
        int aliasCounter = 0;
        while (aliases.hasMoreElements()) {
            ++aliasCounter;
            alias = aliases.nextElement();
        }
        if (aliasCounter != 1) {
            throw new KeyUtilException("The keyfile contains " + aliasCounter + " elements. Only one entry was expected.");
        }
        if (!alias.equals(pubKeyDigestString)) {
            throw new KeyUtilException("The public key in the key file is not the same as the public key in the certificate to import.");
        }
        Key privKey = null;
        try {
            privKey = keyStore.getKey(alias, pw.toCharArray());
        }
        catch (UnrecoverableKeyException uke) {
            throw new KeyUtilException(uke);
        }
        catch (KeyStoreException kse) {
            throw new KeyUtilException(kse);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KeyUtilException(nsae);
        }
        KeyStore pkcs12KeyStore = null;
        try {
            pkcs12KeyStore = KeyStore.getInstance("PKCS12", "BC");
        }
        catch (NoSuchProviderException nspe) {
            throw new KeyUtilException("Provider not present: ", nspe);
        }
        catch (KeyStoreException kse) {
            throw new KeyUtilException("Unable to create keystore: ", kse);
        }
        try {
            pkcs12KeyStore.load(null);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KeyUtilException(nsae);
        }
        catch (CertificateException ce) {
            throw new KeyUtilException(ce);
        }
        catch (IOException ie) {
            throw new KeyUtilException(ie);
        }
        try {
            PKCS12BagAttributeCarrier bagAttr = (PKCS12BagAttributeCarrier)privKey;
            bagAttr.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, (ASN1Encodable)new DERBMPString(pubKeyDigestString));
            bagAttr.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, (ASN1Encodable)new SubjectKeyIdentifier(certificates.get(0).getPublicKey().getEncoded()));
            Certificate[] cs = new Certificate[certificates.size()];
            int count = 0;
            for (Certificate cert : certificates) {
                pkcs12KeyStore.setCertificateEntry(pubKeyDigestString, cert);
                cs[count++] = cert;
            }
            pkcs12KeyStore.setKeyEntry(pubKeyDigestString, privKey, pw.toCharArray(), cs);
        }
        catch (KeyStoreException kse) {
            throw new KeyUtilException(kse);
        }
        try {
            fos = new FileOutputStream(p12File);
        }
        catch (FileNotFoundException fnfe) {
            throw new KeyUtilException(fnfe);
        }
        try {
            pkcs12KeyStore.store(fos, pw.toCharArray());
        }
        catch (KeyStoreException kse) {
            throw new KeyUtilException(kse);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KeyUtilException(nsae);
        }
        catch (CertificateException ce) {
            throw new KeyUtilException(ce);
        }
        catch (IOException ie) {
            throw new KeyUtilException(ie);
        }
        finally {
            if (fos != null) {
                try {
                    fos.flush();
                    fos.close();
                }
                catch (IOException ioe) {
                    throw new KeyUtilException("Unable to close keystore file.", ioe);
                }
            }
        }
        boolean deleted = keyFile.delete();
        if (!deleted) {
            throw new KeyUtilException("Unable to delete keyFile: " + keyFile.getAbsolutePath() + " from file system.");
        }
        System.out.println("Certificate successfully imported. PKC12 file generated at: " + p12File.getAbsolutePath());
    }
}

