/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.keyutil.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.List;
import org.bouncycastle.util.encoders.Base64;

public final class CertificateUtil {
    private static final String pemCertificateHeader = "-----BEGIN CERTIFICATE-----";
    private static final String pemCertificateFooter = "-----END CERTIFICATE-----";
    private static final String pkcs7CertificateHeader = "-----BEGIN PKCS7-----";
    private static final String pkcs7CertificateFooter = "-----END PKCS7-----";
    private static final String pemP10Header = "-----BEGIN CERTIFICATE REQUEST-----";
    private static final String pemP10Footer = "-----END CERTIFICATE REQUEST-----";
    public static final String dummyCertificate = "MIIB0DCCAXoCAQAwDQYJKoZIhvcNAQEEBQAwczELMAkGA1UEBhMCTk8xDjAMBgNVBAgTBWR1bW15MQ4wDAYDVQQHEwVkdW1teTEOMAwGA1UEChMFZHVtbXkxDjAMBgNVBAsTBWR1bW15MQ4wDAYDVQQDEwVkdW1teTEUMBIGCSqGSIb3DQEJARYFZHVtbXkwHhcNMDkxMDA1MTAzNDQ4WhcNMTkxMDAzMTAzNDQ4WjBzMQswCQYDVQQGEwJOTzEOMAwGA1UECBMFZHVtbXkxDjAMBgNVBAcTBWR1bW15MQ4wDAYDVQQKEwVkdW1teTEOMAwGA1UECxMFZHVtbXkxDjAMBgNVBAMTBWR1bW15MRQwEgYJKoZIhvcNAQkBFgVkdW1teTBcMA0GCSqGSIb3DQEBAQUAA0sAMEgCQQCv+OjCwy7Jqt6//AppEgHXMlOorDvGI7gd4/qzqg12sY297aRk3xzc9keXX9sTa5eYJm/Ew6zefZJkBb8hJs7VAgMBAAEwDQYJKoZIhvcNAQEEBQADQQAVu6q9gJmbA/gKrrKopwsm5QnHrR8tkyCbpSiN6QkR+TvtStO/GkHnuMIBy6SIgj39KknuAfCegyhu9VVAuL76";

    private CertificateUtil() {
    }

    public static List<Certificate> getCertificatesFromBytes(byte[] certBytes) {
        List<Certificate> certificates = null;
        try {
            certificates = CertificateUtil.getCertificatesFromDerBytes(certBytes);
            return certificates;
        }
        catch (Exception exception) {
            try {
                certificates = CertificateUtil.getCertificatesFromBase64Bytes(certBytes);
                return certificates;
            }
            catch (Exception exception2) {
                try {
                    certificates = CertificateUtil.getCertificatesFromPemBytes(certBytes);
                    return certificates;
                }
                catch (Exception exception3) {
                    try {
                        certificates = CertificateUtil.getCertificatesFromP7BBytes(certBytes);
                        return certificates;
                    }
                    catch (Exception exception4) {
                        throw new IllegalArgumentException("Unable to create certificate from bytes. Tried DER, PEM, PKCS7 and Base64 encoding formats.");
                    }
                }
            }
        }
    }

    public static List<Certificate> getCertificatesFromDerBytes(byte[] derBytes) {
        List certificate;
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Unable to get X.509 CertificateFacory", e);
        }
        try {
            certificate = (List)certificateFactory.generateCertificates(new ByteArrayInputStream(derBytes));
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("Unable to convert bytes to certificate using DER encoding: " + e.getMessage(), e);
        }
        return certificate;
    }

    public static List<Certificate> getCertificatesFromPemBytes(byte[] pemBytes) {
        String pemCert = new String(pemBytes);
        if (!(pemCert = pemCert.trim()).startsWith(pemCertificateHeader)) {
            throw new IllegalArgumentException("No PEM certificate. Unable to find PEM header.");
        }
        if (!pemCert.endsWith(pemCertificateFooter)) {
            throw new IllegalArgumentException("No PEM certificate.  Unable to find PEM footer.");
        }
        pemCert = pemCert.replace(pemCertificateHeader, "");
        pemCert = pemCert.replace(pemCertificateFooter, "");
        pemCert = pemCert.replaceAll("\\p{Space}", "");
        return CertificateUtil.getCertificatesFromBase64Bytes(pemCert.getBytes());
    }

    public static List<Certificate> getCertificatesFromP7BBytes(byte[] p7bBytes) {
        String pkcs7Cert = new String(p7bBytes);
        if (!(pkcs7Cert = pkcs7Cert.trim()).startsWith(pkcs7CertificateHeader)) {
            throw new IllegalArgumentException("No P7B certificate. Unable to find PKCS7 header.");
        }
        if (!pkcs7Cert.endsWith(pkcs7CertificateFooter)) {
            throw new IllegalArgumentException("No P7B certificate.  Unable to find PKCS7 footer.");
        }
        pkcs7Cert = pkcs7Cert.replace(pkcs7CertificateHeader, "");
        pkcs7Cert = pkcs7Cert.replace(pkcs7CertificateFooter, "");
        pkcs7Cert = pkcs7Cert.replaceAll("\\p{Space}", "");
        return CertificateUtil.getCertificatesFromDerBytes(Base64.decode((byte[])pkcs7Cert.getBytes()));
    }

    public static List<Certificate> getCertificatesFromBase64Bytes(byte[] base64Bytes) {
        return CertificateUtil.getCertificatesFromDerBytes(Base64.decode((byte[])base64Bytes));
    }

    public static String p10BytesToPem(byte[] bytes) {
        try {
            String pem = new String(Base64.encode((byte[])bytes), "ISO-8859-1");
            return "-----BEGIN CERTIFICATE REQUEST-----\n" + pem + "\n" + pemP10Footer;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to Base64 encode bytes.", e);
        }
    }

    public static byte[] getP10FromPemBytes(byte[] pemBytes) {
        String pemP10 = new String(pemBytes);
        if (!(pemP10 = pemP10.trim()).startsWith(pemP10Header)) {
            throw new IllegalArgumentException("No PEM certificate. Unable to find PEM header.");
        }
        if (!pemP10.endsWith(pemP10Footer)) {
            throw new IllegalArgumentException("No PEM certificate.  Unable to find PEM footer.");
        }
        pemP10 = pemP10.replace(pemP10Header, "");
        pemP10 = pemP10.replace(pemP10Footer, "");
        pemP10 = pemP10.replaceAll("\\p{Space}", "");
        return CertificateUtil.getP10FromBase64String(pemP10);
    }

    public static byte[] getP10FromBase64String(String base64String) {
        return Base64.decode((String)base64String);
    }
}

