/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.crypto;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import no.bbs.tt.bc.cryptlib.util.RandomUtil;

public class Crypto {
    public static SecretKey generateTrippelDESKey() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyGenerator kg = KeyGenerator.getInstance("DESede", "BC");
        kg.init(168);
        SecretKey key = kg.generateKey();
        return key;
    }

    public static byte[] wrapKey(Key sk, PublicKey wrapper) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException {
        byte[] encSK = null;
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
        cipher.init(3, wrapper);
        encSK = cipher.wrap(sk);
        return encSK;
    }

    public static byte[] wrapTrippelDESKey(byte[] desedeBytes, PublicKey wrapper) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException {
        byte[] encSK = null;
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
        cipher.init(3, wrapper);
        SecretKey sk = Crypto.generateSecretKeyFromBytes(desedeBytes, "DESede");
        encSK = cipher.wrap(sk);
        return encSK;
    }

    private static SecretKey generateSecretKeyFromBytes(byte[] skBytes, String keyAlgorithm) {
        SecretKeySpec sk = new SecretKeySpec(skBytes, keyAlgorithm);
        return sk;
    }

    public static SecretKey unWrapKey(byte[] skBytes, String keyAlgorithm, PrivateKey pk) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException {
        KeyFactory keyFact = KeyFactory.getInstance("RSA", "BC");
        SecretKey sk = null;
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
        cipher.init(4, pk);
        sk = (SecretKey)cipher.unwrap(skBytes, keyAlgorithm, 3);
        return sk;
    }

    public static SecretKey unWrapTrippelDESKey(byte[] skBytes, PrivateKey pk) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
        cipher.init(4, pk);
        return (SecretKey)cipher.unwrap(skBytes, "DESede", 3);
    }

    public static byte[] encrypt(SecretKey sk, byte[] data) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidParameterSpecException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, InvalidKeyException {
        byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        AlgorithmParameters algParams = AlgorithmParameters.getInstance("DESede", "BC");
        algParams.init(ivSpec);
        Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding", "BC");
        return Crypto.do3DESEnc(data, 0, sk, algParams, cipher);
    }

    public static byte[] encrypt(byte[] skbytes, String keyAlgorithm, byte[] data) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidParameterSpecException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, InvalidKeyException {
        SecretKey sk = Crypto.generateSecretKeyFromBytes(skbytes, keyAlgorithm);
        return Crypto.encrypt(sk, data);
    }

    public static byte[] encryptAppendingSecureRandom(byte[] skbytes, String keyAlgorithm, byte[] data, int randomPaddingLength) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidParameterSpecException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, InvalidKeyException {
        SecretKey sk = Crypto.generateSecretKeyFromBytes(skbytes, keyAlgorithm);
        return Crypto.encryptAppendingSecureRandom(sk, data, randomPaddingLength);
    }

    public static byte[] encryptAppendingSecureRandom(SecretKey sk, byte[] data, int randomPaddingLength) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidParameterSpecException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, InvalidKeyException {
        byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        AlgorithmParameters algParams = AlgorithmParameters.getInstance("DESede", "BC");
        algParams.init(ivSpec);
        Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding", "BC");
        byte[] buf = new byte[data.length + randomPaddingLength];
        byte[] rnd = RandomUtil.getSecureRandomBytes(randomPaddingLength);
        System.arraycopy(rnd, 0, buf, 0, randomPaddingLength);
        System.arraycopy(data, 0, buf, randomPaddingLength, data.length);
        return Crypto.do3DESEnc(buf, 0, sk, algParams, cipher);
    }

    public static byte[] decryptAndRemoveRandomPadding(SecretKey sk, byte[] data, int randomPaddingLength) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidParameterSpecException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, InvalidKeyException {
        byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        AlgorithmParameters algParams = AlgorithmParameters.getInstance("DESede", "BC");
        algParams.init(ivSpec);
        Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding", "BC");
        byte[] buf = Crypto.do3DESDec(data, 0, sk, algParams, cipher);
        byte[] retval = new byte[buf.length - randomPaddingLength];
        System.arraycopy(buf, randomPaddingLength, retval, 0, retval.length);
        return retval;
    }

    public static byte[] decryptAndRemoveRandomPadding(byte[] skbytes, String keyAlgorithm, byte[] data, int randomPaddingLength) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidParameterSpecException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, InvalidKeyException {
        SecretKey sk = Crypto.generateSecretKeyFromBytes(skbytes, keyAlgorithm);
        return Crypto.decryptAndRemoveRandomPadding(sk, data, randomPaddingLength);
    }

    public static byte[] decrypt(SecretKey sk, byte[] data) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidParameterSpecException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, InvalidKeyException {
        byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        AlgorithmParameters algParams = AlgorithmParameters.getInstance("DESede", "BC");
        algParams.init(ivSpec);
        Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding", "BC");
        byte[] buf = Crypto.do3DESDec(data, 0, sk, algParams, cipher);
        return buf;
    }

    public static byte[] decrypt(byte[] skbytes, String keyAlgorithm, byte[] data) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidParameterSpecException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, InvalidKeyException {
        SecretKey sk = Crypto.generateSecretKeyFromBytes(skbytes, keyAlgorithm);
        return Crypto.decrypt(sk, data);
    }

    public static byte[] do3DESEnc(byte[] data, int start, SecretKey key, AlgorithmParameters params, Cipher cipher) throws InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        cipher.init(1, (Key)key, params);
        return cipher.doFinal(data, start, data.length);
    }

    public static byte[] do3DESDec(byte[] data, int start, SecretKey key, AlgorithmParameters params, Cipher cipher) throws InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        cipher.init(2, (Key)key, params);
        return cipher.doFinal(data, start, data.length);
    }
}

