/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.ds;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.crypto.dsig.Reference;
import no.bbs.tt.bc.cryptlib.ds.SignedObject;

public class XMLDSIGContent {
    private List<X509Certificate> certificateChain = null;
    private X509Certificate signerCertificate = null;
    private ArrayList<Reference> references = null;
    private HashMap<String, SignedObject> referencedObjects = null;
    boolean isCustomPropertySignature = false;

    public int getNumberOfSignedObjects() {
        if (null == this.referencedObjects) {
            return 0;
        }
        return this.referencedObjects.size();
    }

    public void addSignedObject(SignedObject so) {
        if (null == so) {
            throw new IllegalArgumentException("XMLDSIGContent.addSignedObject failed. Input SignedObject cannot be null");
        }
        if (null == so.getObjectId()) {
            throw new IllegalArgumentException("XMLDSIGContent.addSignedObject failed. Input SignedObject.getObjectId cannot be null");
        }
        if (null == this.referencedObjects) {
            this.referencedObjects = new HashMap();
        }
        this.referencedObjects.put(so.getObjectId(), so);
    }

    public SignedObject getReferencedObjectById(String objectId) {
        if (null != this.referencedObjects) {
            return this.referencedObjects.get(objectId);
        }
        return null;
    }

    public HashMap<String, SignedObject> getReferencedObjects() {
        return this.referencedObjects;
    }

    public void addReference(Reference reference) {
        if (null == this.references) {
            this.references = new ArrayList();
        }
        this.references.add(reference);
    }

    public void addX509CertificateToChain(X509Certificate cert) {
        if (null == this.certificateChain) {
            this.certificateChain = new ArrayList<X509Certificate>();
        }
        this.certificateChain.add(cert);
    }

    public ArrayList<Reference> getReferences() {
        return this.references;
    }

    public void setReferences(ArrayList<Reference> references) {
        this.references = references;
    }

    public List<X509Certificate> getCertificateChain() {
        return this.certificateChain;
    }

    public void setCertificateChain(List<X509Certificate> certificateChain) {
        this.certificateChain = certificateChain;
    }

    public X509Certificate getSignerCertificate() {
        return this.signerCertificate;
    }

    public void setSignerCertificate(X509Certificate signerCertificate) {
        this.signerCertificate = signerCertificate;
    }

    public boolean isCustomPropertySignature() {
        return this.isCustomPropertySignature;
    }

    public void setCustomPropertySignature(boolean customPropertySignature) {
        this.isCustomPropertySignature = customPropertySignature;
    }
}

