/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.keystore;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.crypto.Cipher;
import no.bbs.tt.bc.cryptlib.keystore.InvalidCertificateChainException;
import no.bbs.tt.bc.cryptlib.keystore.KSException;
import no.bbs.tt.bc.cryptlib.util.BCCryptoLoader;
import no.bbs.tt.bc.cryptlib.util.ByteContainer;
import org.bouncycastle.util.encoders.Base64;

public class PKCS12Keystore {
    protected PrivateKey privateKey = null;
    protected X509Certificate[] certificateChain = null;
    protected X509Certificate leafCertificate = null;

    public PKCS12Keystore() {
        BCCryptoLoader.registerBCProvider();
    }

    public void loadKeystore(String pkcs12File, String pwd) throws KSException {
        try {
            char[] pwdChars = new char[pwd.length()];
            pwd.getChars(0, pwd.length(), pwdChars, 0);
            KeyStore store = KeyStore.getInstance("PKCS12");
            store.load(new FileInputStream(pkcs12File), pwdChars);
            Enumeration<String> ksAliases = store.aliases();
            String keyAlias = null;
            while (ksAliases.hasMoreElements()) {
                String currAlias = ksAliases.nextElement();
                if (!store.isKeyEntry(currAlias)) continue;
                keyAlias = currAlias;
                this.privateKey = (PrivateKey)store.getKey(currAlias, pwdChars);
            }
            if (null == this.privateKey) {
                throw new KSException("Unable to locate PrivateKey in KeyStore [" + pkcs12File + "]");
            }
            Certificate[] certChain = store.getCertificateChain(keyAlias);
            if (null == certChain) {
                throw new KSException("Unable to locate CertificateChain in KeyStore [" + pkcs12File + "]");
            }
            this.certificateChain = this.convertToX509CertificateChain(certChain);
            this.linkChain("RSA", this.certificateChain, this.privateKey);
            this.leafCertificate = this.certificateChain[0];
        }
        catch (Exception e) {
            throw new KSException("Failed to load keystore", e);
        }
    }

    public void loadP12AndRebuildCertChain(String pkcs12File, String pwd, X509Certificate[] certificates) throws KSException {
        try {
            char[] pwdChars = new char[pwd.length()];
            pwd.getChars(0, pwd.length(), pwdChars, 0);
            KeyStore store = KeyStore.getInstance("PKCS12");
            store.load(new FileInputStream(pkcs12File), pwdChars);
            Enumeration<String> ksAliases = store.aliases();
            String keyAlias = null;
            while (ksAliases.hasMoreElements()) {
                String currAlias = ksAliases.nextElement();
                if (!store.isKeyEntry(currAlias)) continue;
                keyAlias = currAlias;
                this.privateKey = (PrivateKey)store.getKey(currAlias, pwdChars);
            }
            if (null == this.privateKey) {
                throw new KSException("Unable to locate PrivateKey in KeyStore [" + pkcs12File + "]");
            }
            Certificate[] p12CertificateChain = store.getCertificateChain(keyAlias);
            if (null == p12CertificateChain) {
                throw new KSException("Unable to locate CertificateChain in KeyStore [" + pkcs12File + "]");
            }
            if (p12CertificateChain.length < 1) {
                throw new KSException("CertificateChain in KeyStore [" + pkcs12File + "] is empty");
            }
            this.leafCertificate = this.convertToX509CertificateChain(p12CertificateChain)[0];
            X509Certificate[] allCertificates = new X509Certificate[certificates.length + p12CertificateChain.length];
            allCertificates[0] = this.leafCertificate;
            for (int i = 0; i < certificates.length; ++i) {
                allCertificates[i + 1] = certificates[i];
            }
            this.certificateChain = this.linkChain("RSA", allCertificates, this.privateKey);
        }
        catch (Exception e) {
            throw new KSException("Failed to load keystore", e);
        }
    }

    public KeyStore loadKeyStore(String provider, InputStream keyStoreStream, String storeType, char[] keyStorePassword) throws KSException {
        String sType = storeType;
        try {
            if (sType == null) {
                sType = "PKCS12";
            }
            KeyStore keyStore = sType.equals("JKS") ? KeyStore.getInstance(sType, "SUN") : (sType.equals("JCEKS") ? KeyStore.getInstance(sType, "SunJCE") : KeyStore.getInstance(sType, provider));
            if (keyStoreStream == null) {
                throw new KSException("Keystore must be specified.");
            }
            keyStore.load(keyStoreStream, keyStorePassword);
            return keyStore;
        }
        catch (KeyStoreException e) {
            throw new KSException("Problem loading keystore: " + e);
        }
        catch (NoSuchProviderException e) {
            throw new KSException("The specified provider is not available.");
        }
        catch (CertificateException ce) {
            throw new KSException("Could not open keystore: " + ce);
        }
        catch (IOException ioe) {
            throw new KSException("Could not export key: " + ioe);
        }
        catch (NoSuchAlgorithmException nse) {
            throw new KSException("Could not open keystore with the installed JCE providers: " + nse);
        }
    }

    protected void exportKey(String provider, PrintStream outStream, InputStream keyStoreStream, String storeType, char[] keyStorePassword, String keyAlias, char[] keyPassword, boolean rfc) throws KSException {
        try {
            KeyStore keyStore = this.loadKeyStore(provider, keyStoreStream, storeType, keyStorePassword);
            if (keyAlias == null) {
                throw new KSException("Key alias must be specified.");
            }
            Key key = keyStore.getKey(keyAlias, keyPassword);
            if (key == null) {
                throw new KSException("Key not found in store.");
            }
            if (rfc) {
                outStream.println("-----BEGIN PRIVATE KEY-----");
                outStream.println(new String(Base64.encode((byte[])key.getEncoded())));
                outStream.println("-----END PRIVATE KEY-----");
            } else {
                outStream.write(key.getEncoded());
            }
        }
        catch (KeyStoreException e) {
            throw new KSException("Problem loading keystore: " + e);
        }
        catch (IOException ioe) {
            throw new KSException("Could not export key: " + ioe);
        }
        catch (NoSuchAlgorithmException nse) {
            throw new KSException("Could not recover key with the installed JCE providers: " + nse);
        }
        catch (UnrecoverableKeyException uke) {
            throw new KSException("The key specified key cannot be recovered with the given password: " + uke);
        }
    }

    protected boolean isMatchingKey(String algorithm, PublicKey pubKey, PrivateKey privKey) {
        try {
            String controlString = "asdf";
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(1, pubKey);
            byte[] encryptedData = cipher.doFinal(controlString.getBytes("UTF-8"));
            cipher.init(2, privKey);
            byte[] decryptedData = cipher.doFinal(encryptedData);
            if (controlString.equals(new String(decryptedData, "UTF-8"))) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected PrivateKey readPrivateKey(String provider, InputStream keyStream, String algorithm) throws KSException {
        try {
            int i;
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm, provider);
            byte[] inputBuffer = new byte[8];
            ByteContainer inputBytes = new ByteContainer(400);
            do {
                i = keyStream.read(inputBuffer);
                for (int j = 0; j < i; ++j) {
                    inputBytes.append(inputBuffer[j]);
                }
            } while (i > -1);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(inputBytes.toByteArray());
            return keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new KSException("Problem reading private key.  Keys should be DER encoded pkcs8 or DER encoded native format.");
        }
    }

    public X509Certificate[] linkChain(String keyAlgorithm, X509Certificate[] untestedCerts, PrivateKey privKey) throws InvalidCertificateChainException {
        int i;
        ArrayList<X509Certificate> replyCerts = new ArrayList<X509Certificate>();
        for (i = 0; untestedCerts.length > i; ++i) {
            try {
                untestedCerts[i].checkValidity();
            }
            catch (Exception e) {
                throw new InvalidCertificateChainException("Invalid CertificateChain. The Certificate with SubjectDN [" + untestedCerts[i].getSubjectDN().getName() + "] is not valid: " + e.getMessage());
            }
            if (!this.isMatchingKey(keyAlgorithm, untestedCerts[i].getPublicKey(), privKey)) continue;
            replyCerts.add(untestedCerts[i]);
        }
        if (replyCerts.size() < 1) {
            throw new InvalidCertificateChainException("No certificate in chain that matches specified private key");
        }
        if (replyCerts.size() > 1) {
            throw new InvalidCertificateChainException("More than one certificate in chain that matches specified private key");
        }
        this.walkChain(untestedCerts, replyCerts);
        for (i = 0; i < replyCerts.size() - 1; ++i) {
            PublicKey pubKey = ((X509Certificate)replyCerts.get(i + 1)).getPublicKey();
            try {
                ((X509Certificate)replyCerts.get(i)).verify(pubKey);
                continue;
            }
            catch (Exception e) {
                throw new InvalidCertificateChainException("Certificate chain cannot be verified: " + e.getMessage());
            }
        }
        return replyCerts.toArray(new X509Certificate[0]);
    }

    protected void walkChain(X509Certificate[] chainSource, ArrayList chainDest) throws InvalidCertificateChainException {
        X509Certificate currentCert = (X509Certificate)chainDest.get(chainDest.size() - 1);
        if (currentCert.getSubjectDN().equals(currentCert.getIssuerDN())) {
            return;
        }
        for (int i = 0; chainSource.length > i; ++i) {
            if (!currentCert.getIssuerDN().equals(chainSource[i].getSubjectDN())) continue;
            chainDest.add(chainSource[i]);
            this.walkChain(chainSource, chainDest);
            return;
        }
        throw new InvalidCertificateChainException("Incomplete cerficate chain.");
    }

    protected X509Certificate[] convertToX509CertificateChain(Certificate[] certs) throws CertificateException {
        X509Certificate[] rcerts = new X509Certificate[certs.length];
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        for (int i = 0; i < certs.length; ++i) {
            X509Certificate c;
            rcerts[i] = c = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certs[i].getEncoded()));
        }
        return rcerts;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getLeafCertificate() {
        if (null == this.certificateChain) {
            return null;
        }
        return this.leafCertificate;
    }

    public X509Certificate[] getCertificateChain() {
        return this.certificateChain;
    }
}

