/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.ocsp;

import java.security.cert.X509Certificate;
import no.bbs.tt.bc.cryptlib.ocsp.BOCSPParseException;
import no.bbs.tt.bc.cryptlib.ocsp.BOCSPValues;
import no.bbs.tt.bc.cryptlib.util.ASN1Util;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;

public class BasicOCSPResponseParser {
    public BOCSPValues parse(byte[] bOcso) throws BOCSPParseException {
        BasicOCSPResp br;
        BOCSPValues res = new BOCSPValues();
        try {
            BasicOCSPResponse b = BasicOCSPResponse.getInstance((Object)ASN1Util.byteArrayToDer(bOcso));
            br = new BasicOCSPResp(b);
        }
        catch (Exception e) {
            throw new BOCSPParseException("verifyBasicOCSPResponse failed. Failed to parse BasicOCSPResponse: " + e.getMessage());
        }
        res.setCreationTime(br.getProducedAt());
        try {
            X509CertificateHolder[] certs = br.getCerts();
            X509Certificate vacert = null;
            if (null != certs) {
                JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();
                jcaX509CertificateConverter.setProvider("BC");
                for (int i = 0; i < certs.length; ++i) {
                    vacert = jcaX509CertificateConverter.getCertificate(certs[i]);
                }
                if (null != vacert) {
                    res.setVaCertificate(vacert);
                }
            }
        }
        catch (Exception e) {
            throw new BOCSPParseException("verifyBasicOCSPResponse failed. Failed to get Certs from BasicOCSPResponse: " + e.getMessage());
        }
        SingleResp[] singleResponses = br.getResponses();
        if (null != singleResponses) {
            CertificateID certId = singleResponses[0].getCertID();
            res.setValidatedCertificateSerialNumber(certId.getSerialNumber().toString());
            res.setNextUpdate(singleResponses[0].getNextUpdate());
            res.setThisUpdate(singleResponses[0].getThisUpdate());
            CertificateStatus cs = singleResponses[0].getCertStatus();
            if (cs == null) {
                res.setValid(true);
                res.setCertificateStatus("GOOD");
            } else if (cs instanceof RevokedStatus) {
                RevokedStatus rs = (RevokedStatus)cs;
                res.setCertificateStatus("REVOKED");
                res.setCertificateStatusReason("" + rs.getRevocationReason());
            } else if (cs instanceof UnknownStatus) {
                res.setCertificateStatus("UNKNOWN");
                res.setCertificateStatusReason("UNKNOWN");
            }
        }
        return res;
    }
}

