/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.pkcs7;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import no.bbs.tt.bc.cryptlib.pkcs7.PKCS7GeneratorException;
import no.bbs.tt.bc.cryptlib.util.ASN1Util;
import no.bbs.tt.bc.cryptlib.util.BCCryptoLoader;
import no.bbs.tt.bc.cryptlib.util.HashUtil;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.ess.OtherCertID;
import org.bouncycastle.asn1.ess.OtherSigningCertificate;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;

public class PKCS7Generator {
    public byte[] signAndCreatePKCS7(PrivateKey privateKey, X509Certificate[] certificateChain, byte[] data, boolean attachData) throws PKCS7GeneratorException {
        BCCryptoLoader.registerBCProvider();
        try {
            CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
            JcaSignerInfoGeneratorBuilder signerInfoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build());
            ContentSigner contentSigner = new JcaContentSignerBuilder(CMSSignedGenerator.DIGEST_SHA256).setProvider("BC").build(privateKey);
            SignerInfoGenerator signerInfoGenerator = signerInfoGeneratorBuilder.build(contentSigner, certificateChain[0]);
            generator.addCertificates((Store)this.getCertStore(certificateChain));
            generator.addSignerInfoGenerator(signerInfoGenerator);
            CMSProcessableByteArray cmsTypedData = new CMSProcessableByteArray(data);
            CMSSignedData signedData = generator.generate((CMSTypedData)cmsTypedData, attachData);
            return signedData.getEncoded();
        }
        catch (Throwable e) {
            throw new PKCS7GeneratorException("PKCS7Generator failed to signAndCreatePKCS7. Reason: " + e.getMessage());
        }
    }

    public byte[] signAndCreatePKCS7WithSAttrs(PrivateKey privateKey, X509Certificate[] certificateChain, String hashAlg, byte[] data, boolean attachData) throws PKCS7GeneratorException {
        BCCryptoLoader.registerBCProvider();
        try {
            ContentInfo encInfo;
            ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
            ASN1EncodableVector signerInfos = new ASN1EncodableVector();
            ASN1ObjectIdentifier contentTypeOID = new ASN1ObjectIdentifier(CMSSignedGenerator.DATA);
            CMSProcessableByteArray content = new CMSProcessableByteArray(data);
            String hashAlgorithm = HashUtil.mapHashAlgorithm(hashAlg);
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm);
            md.update(data);
            byte[] digestBytes = md.digest();
            DEROctetString digest = new DEROctetString(digestBytes);
            AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(new ASN1ObjectIdentifier(hashAlgorithm), (ASN1Encodable)DERNull.INSTANCE);
            signerInfos.add((ASN1Encodable)this.createSignerInfo(certificateChain[0], digAlgId, (ASN1OctetString)digest, privateKey, hashAlgorithm));
            digestAlgs.add((ASN1Encodable)this.makeAlgId(hashAlgorithm, null));
            if (attachData) {
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                try {
                    content.write((OutputStream)bOut);
                }
                catch (IOException e) {
                    throw new PKCS7GeneratorException("encapsulation error: " + e.getMessage());
                }
                BERConstructedOctetString octs = new BERConstructedOctetString(bOut.toByteArray());
                encInfo = new ContentInfo(contentTypeOID, (ASN1Encodable)octs);
            } else {
                encInfo = new ContentInfo(contentTypeOID, null);
            }
            BERSet certificates = null;
            if (certificateChain.length != 0) {
                ASN1EncodableVector v = new ASN1EncodableVector();
                X509Certificate curr = null;
                for (int i = 0; i < certificateChain.length; ++i) {
                    curr = certificateChain[i];
                    if (curr.getSubjectDN().equals(curr.getIssuerDN())) continue;
                    Certificate x509Structure = Certificate.getInstance((Object)ASN1Util.byteArrayToDer(curr.getEncoded()));
                    v.add((ASN1Encodable)x509Structure);
                }
                certificates = new BERSet(v);
            }
            SignedData sd = new SignedData((ASN1Set)new DERSet(digestAlgs), encInfo, certificates, null, (ASN1Set)new DERSet(signerInfos));
            ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, (ASN1Encodable)sd);
            CMSSignedData signedData = new CMSSignedData((CMSProcessable)content, contentInfo);
            return signedData.getEncoded();
        }
        catch (Throwable e) {
            throw new PKCS7GeneratorException("PKCS7Generator failed to signAndCreatePKCS7. Reason: " + e.getMessage());
        }
    }

    private byte[] signWithSoftKeys(PrivateKey privateKey, byte[] toBeSigned, String hashAlg) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = null;
        if (CMSSignedGenerator.DIGEST_SHA1.equalsIgnoreCase(hashAlg)) {
            signature = Signature.getInstance("SHA1WithRSA");
        } else if (CMSSignedGenerator.DIGEST_SHA224.equalsIgnoreCase(hashAlg)) {
            signature = Signature.getInstance("SHA224WithRSA");
        } else if (CMSSignedGenerator.DIGEST_SHA256.equalsIgnoreCase(hashAlg)) {
            signature = Signature.getInstance("SHA256WithRSA");
        } else if (CMSSignedGenerator.DIGEST_SHA384.equalsIgnoreCase(hashAlg)) {
            signature = Signature.getInstance("SHA384WithRSA");
        } else if (CMSSignedGenerator.DIGEST_SHA512.equalsIgnoreCase(hashAlg)) {
            signature = Signature.getInstance("SHA512WithRSA");
        }
        signature.initSign(privateKey);
        signature.update(toBeSigned);
        return signature.sign();
    }

    private SignerInfo createSignerInfo(X509Certificate signerCertificate, AlgorithmIdentifier digestAlgorithm, ASN1OctetString digest, PrivateKey privateKey, String hashAlg) throws PKCS7GeneratorException {
        try {
            Certificate x509Structure = Certificate.getInstance((Object)ASN1Util.byteArrayToDer(signerCertificate.getEncoded()));
            SignerIdentifier signerIdentifier = new SignerIdentifier(new IssuerAndSerialNumber(x509Structure));
            ASN1EncodableVector authAttribVector = new ASN1EncodableVector();
            authAttribVector.add((ASN1Encodable)new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((ASN1Encodable)PKCSObjectIdentifiers.data)));
            authAttribVector.add((ASN1Encodable)new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((ASN1Encodable)digest)));
            authAttribVector.add((ASN1Encodable)new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time(new Date()))));
            MessageDigest md = MessageDigest.getInstance(HashUtil.mapHashAlgorithm("SHA-256"));
            md.update(signerCertificate.getEncoded());
            byte[] digestBytes = md.digest();
            authAttribVector.add((ASN1Encodable)new Attribute(PKCSObjectIdentifiers.id_aa_ets_otherSigCert, (ASN1Set)new DERSet((ASN1Encodable)new OtherSigningCertificate(new OtherCertID(new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256), digestBytes)))));
            DERSet authenticatedAttributes = new DERSet(authAttribVector);
            AlgorithmIdentifier digestEncryptionAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption);
            byte[] pkcs1Bytes = this.signWithSoftKeys(privateKey, authenticatedAttributes.getEncoded("DER"), hashAlg);
            DEROctetString encryptedDigest = new DEROctetString(pkcs1Bytes);
            ASN1Set unauthenticatedAttributes = null;
            SignerInfo signerInfo = new SignerInfo(signerIdentifier, digestAlgorithm, (ASN1Set)authenticatedAttributes, digestEncryptionAlgorithm, (ASN1OctetString)encryptedDigest, unauthenticatedAttributes);
            return signerInfo;
        }
        catch (Exception e) {
            throw new PKCS7GeneratorException("Failed to create SignerInfo: " + e.getMessage());
        }
    }

    private ASN1Primitive makeObj(byte[] encoding) throws IOException {
        if (encoding == null) {
            return null;
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(encoding);
        ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
        return aIn.readObject();
    }

    private AlgorithmIdentifier makeAlgId(String oid, byte[] params) throws IOException {
        if (params != null) {
            return new AlgorithmIdentifier(new ASN1ObjectIdentifier(oid), (ASN1Encodable)this.makeObj(params));
        }
        return new AlgorithmIdentifier(new ASN1ObjectIdentifier(oid), (ASN1Encodable)new DERNull());
    }

    static ASN1Set createBerSetFromList(List derObjects) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        Iterator it = derObjects.iterator();
        while (it.hasNext()) {
            v.add((ASN1Encodable)it.next());
        }
        return new BERSet(v);
    }

    static ASN1Set createBerSetFromArray(List derObjects) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        Iterator it = derObjects.iterator();
        while (it.hasNext()) {
            v.add((ASN1Encodable)it.next());
        }
        return new BERSet(v);
    }

    private JcaCertStore getCertStore(X509Certificate[] certificateChain) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException, CertificateEncodingException {
        int length;
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        int n = length = certificateChain == null ? 0 : certificateChain.length;
        for (int i = 0; i < length; ++i) {
            list.add(certificateChain[i]);
        }
        return new JcaCertStore(list);
    }
}

