/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.pkcs7;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import no.bbs.tt.bc.cryptlib.pkcs7.PKCS7ParserException;
import no.bbs.tt.bc.cryptlib.x509.X509Util;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class PKCS7Parser {
    private CMSSignedData signedData = null;

    public PKCS7Parser(byte[] p7Bytes) throws InstantiationException {
        try {
            this.signedData = new CMSSignedData(p7Bytes);
        }
        catch (Exception e) {
            throw new InstantiationException("Failed to construct PKCS7Parser. input PKCS7 bytes are invalid: " + e.getMessage());
        }
    }

    public HashSet getDigestAlgorithms() {
        ContentInfo content = this.signedData.toASN1Structure();
        SignedData data = SignedData.getInstance((Object)content.getContent());
        HashSet<String> digestalgos = new HashSet<String>();
        Enumeration e = data.getDigestAlgorithms().getObjects();
        while (e.hasMoreElements()) {
            ASN1Sequence s = (ASN1Sequence)e.nextElement();
            ASN1ObjectIdentifier o = (ASN1ObjectIdentifier)s.getObjectAt(0);
            digestalgos.add(o.getId());
        }
        return digestalgos;
    }

    public X509Certificate getSignerCertificate() throws PKCS7ParserException {
        try {
            Store certStore = this.signedData.getCertificates();
            SignerInformation signerInformation = (SignerInformation)this.signedData.getSignerInfos().getSigners().iterator().next();
            Collection certCollection = certStore.getMatches((Selector)signerInformation.getSID());
            Iterator certIt = certCollection.iterator();
            X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate((X509CertificateHolder)certIt.next());
            return cert;
        }
        catch (Exception e) {
            throw new PKCS7ParserException("Failed to getSignerCertificate from PKCS7. Reason: " + e.getMessage());
        }
    }

    public X509Certificate[] getAllCertificates() throws PKCS7ParserException {
        try {
            Store certStore = this.signedData.getCertificates();
            Collection certCollection = certStore.getMatches(null);
            Iterator iter = certCollection.iterator();
            ArrayList<X509Certificate> certsInP7 = new ArrayList<X509Certificate>();
            JcaX509CertificateConverter bc = new JcaX509CertificateConverter();
            bc.setProvider("BC");
            while (iter.hasNext()) {
                X509Certificate cert = bc.getCertificate((X509CertificateHolder)iter.next());
                certsInP7.add(cert);
            }
            if (certsInP7.isEmpty()) {
                return null;
            }
            Object[] tmp = certsInP7.toArray();
            X509Certificate[] res = new X509Certificate[tmp.length];
            System.arraycopy(tmp, 0, res, 0, tmp.length);
            return res;
        }
        catch (Exception e) {
            throw new PKCS7ParserException("Failed to getAllCertificates from PKCS7. Reason: " + e.getMessage());
        }
    }

    public Date getSigningTime() throws PKCS7ParserException {
        try {
            SignerInformationStore signers = this.signedData.getSignerInfos();
            Collection signerCollection = signers.getSigners();
            Iterator i = signerCollection.iterator();
            SignerInformation signer = null;
            if (i.hasNext()) {
                signer = (SignerInformation)i.next();
            }
            if (null == signer) {
                throw new PKCS7ParserException("Failed to get SigningTime from PKCS7. PKCS7 has no signers");
            }
            AttributeTable attrTable = signer.getSignedAttributes();
            if (null == attrTable) {
                if (X509Util.hasVerifiableSignAttrs(this.getSignerCertificate())) {
                    throw new PKCS7ParserException("Failed to get SigningTime from PKCS7. PKCS7 has no signed Attributes");
                }
                return null;
            }
            Attribute signTimeAttr = attrTable.get(CMSAttributes.signingTime);
            if (null == signTimeAttr) {
                if (X509Util.hasVerifiableSignAttrs(this.getSignerCertificate())) {
                    throw new PKCS7ParserException("Failed to get SigningTime from PKCS7. PKCS7 does not containg the signingTime SignedAttributes");
                }
                return null;
            }
            ASN1Set aset = signTimeAttr.getAttrValues();
            ASN1Encodable de = aset.getObjectAt(0);
            ASN1Primitive dero = de.toASN1Primitive();
            ASN1UTCTime sTime = (ASN1UTCTime)dero;
            return sTime.getAdjustedDate();
        }
        catch (Exception e) {
            throw new PKCS7ParserException("Failed to getSigningTime from PKCS7. Reason: " + e.getMessage());
        }
    }
}

