/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import no.bbs.tt.bc.cryptlib.util.BCCryptoLoader;
import org.bouncycastle.cms.CMSSignedGenerator;

public class HashUtil {
    public static byte[] hash(byte[] buf, String alg) throws NoSuchAlgorithmException, NoSuchProviderException {
        BCCryptoLoader.registerBCProvider();
        alg = HashUtil.mapHashAlgorithm(alg);
        MessageDigest md = MessageDigest.getInstance(alg, "BC");
        return md.digest(buf);
    }

    public static String mapHashAlgorithm(String hashAlg) {
        if ("SHA-1".equalsIgnoreCase(hashAlg) || "SHA1".equalsIgnoreCase(hashAlg)) {
            hashAlg = CMSSignedGenerator.DIGEST_SHA1;
        } else if ("SHA-256".equalsIgnoreCase(hashAlg) || "SHA256".equalsIgnoreCase(hashAlg)) {
            hashAlg = CMSSignedGenerator.DIGEST_SHA256;
        } else if ("SHA-384".equalsIgnoreCase(hashAlg) || "SHA384".equalsIgnoreCase(hashAlg)) {
            hashAlg = CMSSignedGenerator.DIGEST_SHA384;
        } else if ("SHA-512".equalsIgnoreCase(hashAlg) || "SHA512".equalsIgnoreCase(hashAlg)) {
            hashAlg = CMSSignedGenerator.DIGEST_SHA512;
        } else if ("MD5".equalsIgnoreCase(hashAlg) || "MD-5".equalsIgnoreCase(hashAlg)) {
            hashAlg = CMSSignedGenerator.DIGEST_MD5;
        } else if ("RIPEMD128".equalsIgnoreCase(hashAlg) || "RIPEMD-128".equalsIgnoreCase(hashAlg)) {
            hashAlg = CMSSignedGenerator.DIGEST_RIPEMD128;
        } else if ("RIPEMD160".equalsIgnoreCase(hashAlg) || "RIPEMD-160".equalsIgnoreCase(hashAlg)) {
            hashAlg = CMSSignedGenerator.DIGEST_RIPEMD160;
        } else if ("RIPEMD256".equalsIgnoreCase(hashAlg) || "RIPEMD-256".equalsIgnoreCase(hashAlg)) {
            hashAlg = CMSSignedGenerator.DIGEST_RIPEMD256;
        }
        return hashAlg;
    }
}

