/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.util;

import java.util.HashMap;

public class OIDLookup {
    public static final String OID_DIGEST_SHA128 = "1.3.14.3.2.26";
    public static final String OID_DIGEST_SHA256 = "2.16.840.1.101.3.4.2.1";
    public static final String OID_DIGEST_SHA384 = "2.16.840.1.101.3.4.2.2";
    public static final String OID_DIGEST_SHA512 = "2.16.840.1.101.3.4.2.3";
    public static final String OID_DIGEST_MD2 = "1.2.840.113549.2.2";
    public static final String OID_DIGEST_MD5 = "1.2.840.113549.2.5";
    public static final String OID_DIGEST_RIPEMD128 = "1.3.36.3.2.2";
    public static final String OID_DIGEST_RIPEMD160 = "1.3.36.3.2.1";
    public static final String OID_DIGEST_RIPEMD256 = "1.3.36.3.2.3";
    public static final String TAG_DIGEST_SHA128 = "SHA-1";
    public static final String TAG_DIGEST_SHA256 = "SHA-256";
    public static final String TAG_DIGEST_SHA384 = "SHA-384";
    public static final String TAG_DIGEST_SHA512 = "SHA-512";
    public static final String TAG_DIGEST_MD2 = "MD2";
    public static final String TAG_DIGEST_MD5 = "MD5";
    public static final String TAG_DIGEST_RIPEMD128 = "RIPEMD-128";
    public static final String TAG_DIGEST_RIPEMD160 = "RIPEMD-160";
    public static final String TAG_DIGEST_RIPEMD256 = "RIPEMD-256";
    public static HashMap<String, String> NAME2OIDMAP = null;
    public static HashMap<String, String> OID2NAMEMAP = null;

    public static String getOidByDigestName(String hName) {
        return NAME2OIDMAP.get(hName.toLowerCase());
    }

    public static String getDigestNameByOid(String id) {
        return OID2NAMEMAP.get(id);
    }

    public static boolean hasDigest(String key) {
        return NAME2OIDMAP.containsKey(key.toLowerCase()) || OID2NAMEMAP.containsKey(key.toLowerCase());
    }

    static {
        NAME2OIDMAP = new HashMap();
        NAME2OIDMAP.put(TAG_DIGEST_SHA128.toLowerCase(), OID_DIGEST_SHA128);
        NAME2OIDMAP.put(TAG_DIGEST_SHA256.toLowerCase(), OID_DIGEST_SHA256);
        NAME2OIDMAP.put(TAG_DIGEST_SHA384.toLowerCase(), OID_DIGEST_SHA384);
        NAME2OIDMAP.put(TAG_DIGEST_SHA512.toLowerCase(), OID_DIGEST_SHA512);
        NAME2OIDMAP.put(TAG_DIGEST_MD2.toLowerCase(), OID_DIGEST_MD2);
        NAME2OIDMAP.put(TAG_DIGEST_MD5.toLowerCase(), OID_DIGEST_MD5);
        NAME2OIDMAP.put(TAG_DIGEST_RIPEMD128.toLowerCase(), OID_DIGEST_RIPEMD128);
        NAME2OIDMAP.put(TAG_DIGEST_RIPEMD160.toLowerCase(), OID_DIGEST_RIPEMD160);
        NAME2OIDMAP.put(TAG_DIGEST_RIPEMD256.toLowerCase(), OID_DIGEST_RIPEMD256);
        OID2NAMEMAP = new HashMap();
        OID2NAMEMAP.put(OID_DIGEST_SHA128, TAG_DIGEST_SHA128);
        OID2NAMEMAP.put(OID_DIGEST_SHA256, TAG_DIGEST_SHA256);
        OID2NAMEMAP.put(OID_DIGEST_SHA384, TAG_DIGEST_SHA384);
        OID2NAMEMAP.put(OID_DIGEST_SHA512, TAG_DIGEST_SHA512);
        OID2NAMEMAP.put(OID_DIGEST_MD2, TAG_DIGEST_MD2);
        OID2NAMEMAP.put(OID_DIGEST_MD5, TAG_DIGEST_MD5);
        OID2NAMEMAP.put(OID_DIGEST_RIPEMD128, TAG_DIGEST_RIPEMD128);
        OID2NAMEMAP.put(OID_DIGEST_RIPEMD160, TAG_DIGEST_RIPEMD160);
        OID2NAMEMAP.put(OID_DIGEST_RIPEMD256, TAG_DIGEST_RIPEMD256);
    }
}

