/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.x509;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import no.bbs.tt.bc.cryptlib.util.BCCryptoLoader;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509ExtensionUtils;
import org.bouncycastle.cert.X509v1CertificateBuilder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;

public class X509Builder {
    private X500Name issuerDN;
    private X500Name subjectDN;
    private BigInteger serial = BigInteger.ONE;
    private KeyPair issuerPair = null;
    private KeyPair subjectPair = null;
    private String signHashAlgo = "SHA256withRSA";
    private Date notBefore = new Date(System.currentTimeMillis());
    private Date notAfter = new Date(System.currentTimeMillis());
    private final Map<ASN1ObjectIdentifier, String> extensions = new HashMap<ASN1ObjectIdentifier, String>();
    private final List<ASN1ObjectIdentifier> criticality = new ArrayList<ASN1ObjectIdentifier>();
    private String aiaUrl = null;
    private final List<DistributionPointName> distributionPoints = new ArrayList<DistributionPointName>();

    public X509Builder() {
        BCCryptoLoader.registerBCProvider();
    }

    public X509Builder setSubjectDN(X500Name subjectDN) {
        this.subjectDN = subjectDN;
        return this;
    }

    public X509Builder setIssuerDN(X500Name subjectDN) {
        this.issuerDN = subjectDN;
        return this;
    }

    public X509Builder setIssuerKeypair(KeyPair issuerPair) {
        this.issuerPair = issuerPair;
        return this;
    }

    public X509Builder setSubjectKeypair(KeyPair subjectPair) {
        this.subjectPair = subjectPair;
        return this;
    }

    public X509Builder setSerialNumber(BigInteger serial) {
        this.serial = serial;
        return this;
    }

    public X509Builder setSignHashAlgorithm(String hashAlgName) {
        this.signHashAlgo = hashAlgName;
        return this;
    }

    public X509Builder setValidityDates(Date notBefore, Date notAfter) {
        this.notBefore = notBefore;
        if (!notAfter.after(notBefore)) {
            throw new IllegalArgumentException("Certificate not-after date must be after not-before date");
        }
        this.notAfter = notAfter;
        return this;
    }

    public X509Builder addExtension(ASN1ObjectIdentifier oid, String value) {
        this.extensions.put(oid, value);
        return this;
    }

    public X509Builder addCriticalExtension(ASN1ObjectIdentifier oid) {
        this.criticality.add(oid);
        return this;
    }

    public X509Certificate build() throws CertificateException, IOException, NoSuchProviderException, OperatorCreationException {
        X509CertificateHolder certificate = this.generateCertificate();
        ByteArrayInputStream in = new ByteArrayInputStream(certificate.toASN1Structure().getEncoded());
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509Certificate)cf.generateCertificate(in);
    }

    private X509CertificateHolder generateCertificate() throws IOException, OperatorCreationException {
        SubjectPublicKeyInfo subjectPubKeyInfo = this.generatePublicKeyInfo(this.subjectPair.getPublic());
        X509CertBuilderType certBuilder = this.subjectDN.toString().equals(this.issuerDN.toString()) ? this.initV1CertBuilder(subjectPubKeyInfo) : this.initV3CertBuilder(subjectPubKeyInfo);
        SubjectPublicKeyInfo issuerPubKeyInfo = this.generatePublicKeyInfo(this.issuerPair.getPublic());
        this.addKeyIdentifiers(subjectPubKeyInfo, issuerPubKeyInfo, certBuilder);
        this.addCRLSitributionPoints(certBuilder);
        this.addAuthorityInformationAccess(certBuilder);
        this.addExtensions(certBuilder);
        ContentSigner sigGen = this.generateContentSignerBuilder(this.issuerPair.getPrivate());
        X509CertificateHolder certHolder = certBuilder.build(sigGen);
        return certHolder;
    }

    private ContentSigner generateContentSignerBuilder(PrivateKey issuerPrivateKey) throws OperatorCreationException, IOException {
        AsymmetricKeyParameter privateKeyParam = PrivateKeyFactory.createKey((byte[])issuerPrivateKey.getEncoded());
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(this.signHashAlgo);
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        return new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(privateKeyParam);
    }

    public X509Builder setAuthorityInformationAccessUrl(String url) {
        this.aiaUrl = url;
        return this;
    }

    public X509Builder addCRLSitributionPoint(String url) {
        this.distributionPoints.add(new DistributionPointName(new GeneralNames(new GeneralName(6, url))));
        return this;
    }

    private X509Builder addAuthorityInformationAccess(X509CertBuilderType builder) throws CertIOException {
        if (null != this.aiaUrl) {
            AccessDescription caIssuers = new AccessDescription(AccessDescription.id_ad_caIssuers, new GeneralName(6, (ASN1Encodable)new DERIA5String(this.aiaUrl)));
            ASN1EncodableVector aia_ASN = new ASN1EncodableVector();
            aia_ASN.add((ASN1Encodable)caIssuers);
            builder.addExtension(Extension.authorityInfoAccess, false, (ASN1Encodable)new DERSequence(aia_ASN));
        }
        return this;
    }

    private void addKeyIdentifiers(SubjectPublicKeyInfo subjectKeyInfo, SubjectPublicKeyInfo issuerKeyInfo, X509CertBuilderType builder) throws OperatorCreationException, CertIOException {
        DigestCalculator digCalc = new BcDigestCalculatorProvider().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1));
        X509ExtensionUtils x509ExtensionUtils = new X509ExtensionUtils(digCalc);
        builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)x509ExtensionUtils.createSubjectKeyIdentifier(subjectKeyInfo));
        builder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)x509ExtensionUtils.createAuthorityKeyIdentifier(issuerKeyInfo));
    }

    private void addCRLSitributionPoints(X509CertBuilderType builder) throws CertIOException {
        if (!this.distributionPoints.isEmpty()) {
            DistributionPoint[] distPoints = new DistributionPoint[this.distributionPoints.size()];
            for (int i = 0; i < distPoints.length; ++i) {
                distPoints[i] = new DistributionPoint(this.distributionPoints.get(i), null, null);
            }
            builder.addExtension(Extension.cRLDistributionPoints, false, (ASN1Encodable)new CRLDistPoint(distPoints));
        }
    }

    private X509Builder addExtensions(X509CertBuilderType builder) throws CertIOException {
        if (null != this.extensions) {
            for (ASN1ObjectIdentifier k : this.extensions.keySet()) {
                builder.addExtension(k, this.criticality.contains(k), (ASN1Encodable)new DERPrintableString(this.extensions.get(k)));
            }
        }
        return this;
    }

    private X509CertBuilderType initV3CertBuilder(SubjectPublicKeyInfo subjectPubKeyInfo) {
        return new V3CertBuilder(this.issuerDN, this.serial, this.notBefore, this.notAfter, this.subjectDN, subjectPubKeyInfo);
    }

    private X509CertBuilderType initV1CertBuilder(SubjectPublicKeyInfo subjectPubKeyInfo) {
        return new V1CertBuilder(this.issuerDN, this.serial, this.notBefore, this.notAfter, this.subjectDN, subjectPubKeyInfo);
    }

    private SubjectPublicKeyInfo generatePublicKeyInfo(PublicKey publicKey) {
        byte[] encodedPublicKey = publicKey.getEncoded();
        return SubjectPublicKeyInfo.getInstance((Object)ASN1Sequence.getInstance((Object)encodedPublicKey));
    }

    private class V1CertBuilder
    extends X509v1CertificateBuilder
    implements X509CertBuilderType {
        public V1CertBuilder(X500Name xn, BigInteger bi, Date date, Date date1, X500Name xn1, SubjectPublicKeyInfo spki) {
            super(xn, bi, date, date1, xn1, spki);
        }

        @Override
        public X509v3CertificateBuilder addExtension(ASN1ObjectIdentifier asnoi, boolean bln, ASN1Encodable asne) throws CertIOException {
            return null;
        }
    }

    private class V3CertBuilder
    extends X509v3CertificateBuilder
    implements X509CertBuilderType {
        public V3CertBuilder(X500Name xn, BigInteger bi, Date date, Date date1, X500Name xn1, SubjectPublicKeyInfo spki) {
            super(xn, bi, date, date1, xn1, spki);
        }

        @Override
        public X509v3CertificateBuilder addExtension(ASN1ObjectIdentifier asnoi, boolean bln, ASN1Encodable asne) throws CertIOException {
            super.addExtension(asnoi, bln, asne);
            return null;
        }
    }

    private static interface X509CertBuilderType {
        public X509v3CertificateBuilder addExtension(ASN1ObjectIdentifier var1, boolean var2, ASN1Encodable var3) throws CertIOException;

        public X509CertificateHolder build(ContentSigner var1);
    }
}

