/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.x509;

import no.bbs.tt.bc.cryptlib.x509.X509Parser;

public class X509PrettyPrinter {
    public static void printX509Contents(X509Parser x) throws Exception {
        String[] ku;
        String[] pi;
        System.out.println("SubjectName      : " + x.getSubjectName());
        System.out.println("IssuerName       : " + x.getIssuerName());
        System.out.println("Commonname       : " + x.getCommonName());
        System.out.println("RSAPublicKeySize : " + x.getRSAPublicKeySize());
        System.out.println("SubSerialNumber  : " + x.getSubjectSerial());
        System.out.println("SerialNumber     : " + x.getSerialNumberAsString());
        System.out.println("OrganizationName : " + x.getOrganizationName());
        System.out.println("Country          : " + x.getCountry());
        System.out.println("NotAfter         : " + x.getNotAfter());
        System.out.println("NotBefore        : " + x.getNotBefore());
        System.out.println("NemID PID        : " + x.getNemIDPid());
        System.out.println("OrganizationUnit : " + x.getOrganizationUnit());
        System.out.println("NemID PID        : " + x.getNemIDPid());
        System.out.println("EmailAddress     : " + x.getEmailAddress());
        System.out.println("hasNemIDPseudonym: " + x.hasNemIDPseudonym());
        System.out.println("isNemIDYouth     : " + x.isNemIDYouthCertificate());
        System.out.println("FingerPrint(SHA1): " + x.doFingerprint("SHA-1"));
        String[] ocspResp = x.getOCSPResponderURIs();
        if (null != ocspResp) {
            for (int i = 0; i < ocspResp.length; ++i) {
                System.out.println("OCSPResponder[" + i + "]: " + ocspResp[i]);
            }
        }
        if (null != (pi = x.getPolicyIdentifiers())) {
            for (int x1 = 0; x1 < pi.length; ++x1) {
                System.out.println("PolicyIdentifier[" + x1 + "]: " + pi[x1]);
            }
        }
        if (null != (ku = x.getKeyUsageNames())) {
            for (int x1 = 0; x1 < ku.length; ++x1) {
                System.out.println("KeyUsage[" + x1 + "]: " + ku[x1]);
            }
        }
        System.out.println("extractPartitionedCRLDistributionPoint: " + x.extractPartitionedCRLDistributionPoint());
        System.out.println("extractFullCrlDistributionPoint       : " + x.extractFullCrlDistributionPoint());
    }
}

