/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.sis.common.dhc;

import java.net.URL;

public class DHCConfig {
    private String url = null;
    private String proxyHost = null;
    private String proxyPort = null;
    private String proxyUser = null;
    private String proxyPass = null;
    private String keyStorePath = null;
    private String keyStorePass = null;
    private String keyStoreType = null;
    private String keyStoreAlias = null;
    private boolean hasKeyStoreAlias = false;
    private String trustStorePath = null;
    private String trustStorePwd = null;
    private String trustStoreType = null;
    private int socketTimeout = 0;
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private int connectRetryCount = 0;
    private boolean isHttpsURL = false;
    private boolean isContentCompression = false;
    private String httpBasicAuthUser = null;
    private String httpBasicAuthPass = null;
    private boolean followRedirects = false;
    private boolean useExpectContinue = false;
    private String supportedProtocols = "TLSv1";
    private String supportedCiphers = null;

    public boolean followRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirectStrategy(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public boolean useExpectContinue() {
        return this.useExpectContinue;
    }

    public void setUseExpectContinue(boolean useExpectContinue) {
        this.useExpectContinue = useExpectContinue;
    }

    public String getHttpBasicAuthUser() {
        return this.httpBasicAuthUser;
    }

    public void setHttpBasicAuthUser(String httpBasicAuthUser) {
        this.httpBasicAuthUser = httpBasicAuthUser;
    }

    public String getHttpBasicAuthPass() {
        return this.httpBasicAuthPass;
    }

    public void setHttpBasicAuthPass(String httpBasicAuthPwd) {
        this.httpBasicAuthPass = httpBasicAuthPwd;
    }

    public boolean isHttpBasicAuthentication() {
        return null != this.httpBasicAuthUser && null != this.httpBasicAuthPass;
    }

    public void setContentCompression(boolean contentCompression) {
        this.isContentCompression = contentCompression;
    }

    public boolean isContentCompression() {
        return this.isContentCompression;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        if (null == url) {
            throw new IllegalArgumentException("DHCConfig input url is null");
        }
        try {
            URL u = new URL(url);
            if ("https".equalsIgnoreCase(u.getProtocol())) {
                this.isHttpsURL = true;
            }
        }
        catch (Exception mue) {
            throw new IllegalArgumentException("DHCConfig URL is malformed: " + mue.getMessage());
        }
        this.url = url;
    }

    public boolean isHttpsURL() {
        return this.isHttpsURL;
    }

    public void setSupportedProtocols(String protocols) {
        this.supportedProtocols = protocols;
    }

    public String[] getSupportedProtocolsArray() {
        if (null != this.supportedProtocols) {
            return this.supportedProtocols.split("[,;]");
        }
        return null;
    }

    public void setSupportedCiphers(String ciphers) {
        this.supportedCiphers = ciphers;
    }

    public String[] getSupportedCiphersArray() {
        if (null != this.supportedCiphers) {
            return this.supportedCiphers.split("[,;]");
        }
        return null;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        if (null != proxyHost && proxyHost.trim().length() > 0) {
            this.proxyHost = proxyHost;
        }
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        if (null != proxyPort) {
            this.proxyPort = proxyPort;
        }
    }

    public boolean isProxyTunneling() {
        return null != this.proxyHost && null != this.proxyPort;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStore) {
        if (null != keyStore) {
            this.keyStorePath = keyStore.trim();
            this.keyStoreType = this.storeTypeFromPath(this.keyStorePath);
        }
    }

    public String getKeyStorePass() {
        return this.keyStorePass;
    }

    public void setKeyStorePass(String keyStorePwd) {
        if (null != keyStorePwd) {
            this.keyStorePass = keyStorePwd;
        }
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        if (null != keyStoreType) {
            this.keyStoreType = keyStoreType;
        }
    }

    public String getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    public void setKeyStoreAlias(String keyStoreAlias) {
        if (null != keyStoreAlias) {
            this.keyStoreAlias = keyStoreAlias;
            this.hasKeyStoreAlias = true;
        } else {
            this.hasKeyStoreAlias = false;
        }
    }

    public boolean hasKeyStoreAlias() {
        return this.hasKeyStoreAlias;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public void setTrustStorePath(String trustStore) {
        if (null != trustStore) {
            this.trustStorePath = trustStore.trim();
            this.trustStoreType = this.storeTypeFromPath(this.trustStorePath);
        }
    }

    public String getTrustStorePass() {
        return this.trustStorePwd;
    }

    public void setTrustStorePass(String trustStorePwd) {
        if (null != trustStorePwd) {
            this.trustStorePwd = trustStorePwd;
        }
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        if (null != trustStoreType) {
            this.trustStoreType = trustStoreType;
        }
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        if (null != proxyUser) {
            this.proxyUser = proxyUser;
        }
    }

    public String getProxyPass() {
        return this.proxyPass;
    }

    public void setProxyPass(String proxyPwd) {
        if (null != proxyPwd) {
            this.proxyPass = proxyPwd;
        }
    }

    public boolean isProxyAuthentication() {
        return null != this.proxyUser && null != this.proxyPass;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int timeout) {
        if (timeout > -1) {
            this.connectTimeout = timeout;
        }
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int timeout) {
        if (timeout > -1) {
            this.socketTimeout = timeout;
        }
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int timeout) {
        if (timeout > -1) {
            this.readTimeout = timeout;
        }
    }

    public int getConnectRetryCount() {
        return this.connectRetryCount;
    }

    public void setConnectRetryCount(int connectRetryCount) {
        this.connectRetryCount = connectRetryCount;
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        sb.append("DHCConfig [URL=").append(this.getUrl()).append("]");
        sb.append("[ProxyHost=").append(this.getProxyHost()).append("]");
        sb.append("[ProxyPort=").append(this.getProxyPort()).append("]");
        sb.append("[ProxyUser=").append(this.getProxyUser()).append("]");
        sb.append("[HTTPUser=").append(this.getHttpBasicAuthUser()).append("]");
        return sb.toString();
    }

    private String storeTypeFromPath(String path) {
        if (path.toLowerCase().endsWith(".p12") || path.toLowerCase().endsWith(".pkcs12")) {
            return "PKCS12";
        }
        return "JKS";
    }
}

