/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.messages;

import java.util.ArrayList;
import no.bbs.tt.trustsign.tsm.xml.messages.BaseRequestMessage;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.NameValuePair;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.TimeFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GetOrdersRequest
extends BaseRequestMessage {
    private static final long serialVersionUID = 2167932283764307108L;
    private String orderStatusFilter = null;
    private ArrayList<NameValuePair> nameValuePairs = new ArrayList();
    private String localSignerReference = null;
    private String signerStatus = null;
    private TimeFilter timeFilter = null;

    public GetOrdersRequest() {
        this.setType("GetOrders");
    }

    public GetOrdersRequest(Document doc) {
        super("GetOrders", doc);
        this.setType("GetOrders");
        NodeList nl = doc.getElementsByTagName("OrderStatusFilter");
        if (nl.getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setOrderStatusFilter(nl.item(0).getFirstChild().getNodeValue());
        }
        if ((nl = doc.getElementsByTagName("SignerFilter")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            Element presentationELem = (Element)nl.item(0);
            if ((nl = presentationELem.getElementsByTagName("LocalSignerReference")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
                this.setLocalSignerReference(nl.item(0).getFirstChild().getNodeValue());
            }
            if ((nl = presentationELem.getElementsByTagName("SignerStatus")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
                this.setSignerStatus(nl.item(0).getFirstChild().getNodeValue());
            }
        }
        if ((nl = doc.getElementsByTagName("MetaDataFilter")).getLength() > 0) {
            NodeList childs = ((Element)nl.item(0)).getElementsByTagName("NameValuePair");
            for (int i = 0; i < childs.getLength(); ++i) {
                this.nameValuePairs.add(new NameValuePair((Element)childs.item(i)));
            }
        }
        if ((nl = doc.getElementsByTagName("TimeFilter")).getLength() > 0) {
            Element timeFilterElement = (Element)nl.item(0);
            this.timeFilter = new TimeFilter(timeFilterElement);
        }
    }

    @Override
    public Document toXML() {
        Document doc = super.toXML();
        Element root = this.toXMLHeader("GetOrders", doc);
        if (null != this.getOrderStatusFilter()) {
            Element childElement = doc.createElement("OrderStatusFilter");
            childElement.appendChild(doc.createTextNode(this.getOrderStatusFilter()));
            root.appendChild(childElement);
        }
        if (null != this.getLocalSignerReference()) {
            Element signerFilterElement = doc.createElement("SignerFilter");
            Element localSignRefElem = doc.createElement("LocalSignerReference");
            localSignRefElem.appendChild(doc.createTextNode(this.getLocalSignerReference()));
            signerFilterElement.appendChild(localSignRefElem);
            if (null != this.getSignerStatus()) {
                Element signerStatusElem = doc.createElement("SignerStatus");
                signerStatusElem.appendChild(doc.createTextNode(this.getSignerStatus()));
                signerFilterElement.appendChild(signerStatusElem);
            }
            root.appendChild(signerFilterElement);
        }
        if (this.nameValuePairs.size() > 0) {
            Element metadataElement = doc.createElement("MetaDataFilter");
            for (int i = 0; i < this.nameValuePairs.size(); ++i) {
                NameValuePair nvpair = this.nameValuePairs.get(i);
                metadataElement.appendChild(nvpair.toXML(doc));
            }
            root.appendChild(metadataElement);
        }
        if (null != this.getTimeFilter()) {
            root.appendChild(this.getTimeFilter().toXML(doc));
        }
        doc.getFirstChild().appendChild(root);
        return doc;
    }

    public TimeFilter getTimeFilter() {
        return this.timeFilter;
    }

    public void setTimeFilter(TimeFilter timeFilter) {
        this.timeFilter = timeFilter;
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    public String getOrderStatusFilter() {
        return this.orderStatusFilter;
    }

    public void setOrderStatusFilter(String orderStatusFilter) {
        this.orderStatusFilter = orderStatusFilter;
    }

    public ArrayList<NameValuePair> getNameValuePairs() {
        return this.nameValuePairs;
    }

    public void setNameValuePairs(ArrayList<NameValuePair> nameValuePairs) {
        this.nameValuePairs = nameValuePairs;
    }

    public void addMetaData(String key, String value) {
        if (null != key && null != value) {
            this.nameValuePairs.add(new NameValuePair(key, value));
        }
    }

    public String getLocalSignerReference() {
        return this.localSignerReference;
    }

    public void setLocalSignerReference(String localSignerReference) {
        this.localSignerReference = localSignerReference;
    }

    public String getSignerStatus() {
        return this.signerStatus;
    }

    public void setSignerStatus(String signerStatus) {
        this.signerStatus = signerStatus;
    }
}

