/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.messages;

import no.bbs.tt.trustsign.tsm.xml.messages.BaseRequestMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ValidateSDORequest
extends BaseRequestMessage {
    private static final long serialVersionUID = -5450972823828427280L;
    private String b64SDOBytes = null;
    private boolean sdoSealed = false;

    public ValidateSDORequest() {
    }

    public ValidateSDORequest(Document doc) {
        super("ValidateSDO", doc);
        String sealed;
        this.setType("ValidateSDO");
        NodeList nl = doc.getElementsByTagName("B64SDOBytes");
        if (nl.getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setB64SDOBytes(nl.item(0).getFirstChild().getNodeValue());
        }
        if ((nl = doc.getElementsByTagName("SDOSealed")).getLength() > 0 && nl.item(0).getFirstChild() != null && "true".equalsIgnoreCase(sealed = nl.item(0).getFirstChild().getNodeValue())) {
            this.sdoSealed = true;
        }
    }

    @Override
    public Document toXML() {
        Document doc = super.toXML();
        Element root = this.toXMLHeader("ValidateSDO", doc);
        if (null != this.getB64SDOBytes()) {
            Element childElement = doc.createElement("B64SDOBytes");
            childElement.appendChild(doc.createTextNode(this.getB64SDOBytes()));
            root.appendChild(childElement);
        }
        String sealed = "false";
        if (this.isSdoSealed()) {
            sealed = "true";
        }
        Element childElement = doc.createElement("SDOSealed");
        childElement.appendChild(doc.createTextNode(sealed));
        root.appendChild(childElement);
        doc.getFirstChild().appendChild(root);
        return doc;
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    public String getB64SDOBytes() {
        return this.b64SDOBytes;
    }

    public void setB64SDOBytes(String bytes) {
        this.b64SDOBytes = bytes;
    }

    public boolean isSdoSealed() {
        return this.sdoSealed;
    }

    public void setSdoSealed(boolean sdoSealed) {
        this.sdoSealed = sdoSealed;
    }
}

