/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.messages.containers;

import java.util.ArrayList;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.Authentication;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.IPKI;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.SignerID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Nets
implements IPKI {
    private static final long serialVersionUID = 8102835361981948839L;
    private ArrayList<Authentication> authentications = new ArrayList();
    private ArrayList<SignerID> signerIDs = new ArrayList();
    private boolean signersPopulated = false;

    public Nets() {
    }

    public Nets(Element element) {
        NodeList nl = element.getElementsByTagName("Authentication");
        if (nl.getLength() > 0 && nl.item(0).getFirstChild() != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                this.addAuthentication(new Authentication((Element)nl.item(i)));
            }
        }
    }

    @Override
    public Element toXML(Document doc) {
        Element root = doc.createElement("Nets");
        for (int i = 0; i < this.authentications.size(); ++i) {
            root.appendChild(this.authentications.get(i).toXML(doc));
        }
        doc.getFirstChild().appendChild(root);
        return root;
    }

    public ArrayList<Authentication> getAuthentications() {
        return this.authentications;
    }

    public void addAuthentication(Authentication authentication) {
        this.authentications.add(authentication);
    }

    @Override
    public ArrayList<SignerID> getSignerIDs() {
        if (!this.signersPopulated && this.authentications.size() > 0) {
            for (Authentication a : this.authentications) {
                if (a.getSignerIDs() == null) continue;
                this.signerIDs.addAll(a.getSignerIDs());
            }
            this.signersPopulated = true;
        }
        return this.signerIDs;
    }

    @Override
    public SignerID getSignerID() {
        if (this.signerIDs.size() > 0) {
            return this.signerIDs.get(0);
        }
        return null;
    }

    @Override
    public String getPKIVendor() {
        return "Nets";
    }
}

