/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class DateUtility {
    private static final ThreadLocal<Object> DATE_PARSER_THREAD_LOCAL_NO_TIME_FORMAT = new ThreadLocal<Object>(){

        @Override
        protected Object initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    private static final ThreadLocal<?> DATE_PARSER_THREAD_LOCAL_NORMAL_TIME_FORMAT = new ThreadLocal<Object>(){

        @Override
        protected Object initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd:HH:mm:ss");
        }
    };
    private static final ThreadLocal<?> DATE_PARSER_THREAD_LOCAL_WITH_TZ = new ThreadLocal<Object>(){

        @Override
        protected Object initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        }
    };

    public static Date XMLToDate(String str) {
        Calendar cal;
        if (str.length() > 20) {
            int tzPos = str.indexOf(43);
            if (tzPos == -1) {
                tzPos = str.indexOf(45, 10);
            }
            if (tzPos == -1) {
                cal = Calendar.getInstance();
            } else {
                TimeZone tz = TimeZone.getTimeZone("GMT" + str.substring(tzPos));
                cal = Calendar.getInstance(tz);
            }
        } else {
            cal = Calendar.getInstance();
        }
        cal.set(1, Integer.parseInt(str.substring(0, 4)));
        cal.set(2, Integer.parseInt(str.substring(5, 7)) - 1);
        cal.set(5, Integer.parseInt(str.substring(8, 10)));
        if (str.length() > 12) {
            cal.set(11, Integer.parseInt(str.substring(11, 13)));
            cal.set(12, Integer.parseInt(str.substring(14, 16)));
            cal.set(13, Integer.parseInt(str.substring(17, 19)));
            cal.set(14, 0);
        }
        return cal.getTime();
    }

    public static String DateToXML(Date date) {
        String dateStr = ((DateFormat)DATE_PARSER_THREAD_LOCAL_WITH_TZ.get()).format(date);
        String sub1 = dateStr.substring(0, dateStr.length() - 2);
        String sub2 = dateStr.substring(dateStr.length() - 2, dateStr.length());
        return sub1 + ":" + sub2;
    }

    public static Date DateStringToDate(String dateStr) throws ParseException {
        return ((DateFormat)DATE_PARSER_THREAD_LOCAL_NO_TIME_FORMAT.get()).parse(dateStr);
    }

    public static String DateToXMLDate(Date date) {
        return ((DateFormat)DATE_PARSER_THREAD_LOCAL_NO_TIME_FORMAT.get()).format(date);
    }

    public static String DateToNormalDate(Date d) {
        return ((DateFormat)DATE_PARSER_THREAD_LOCAL_NORMAL_TIME_FORMAT.get()).format(d);
    }

    public static Calendar getCalendarTime(String time) throws NumberFormatException {
        if (time.indexOf(":") == -1 || time.indexOf(":") != time.lastIndexOf(":")) {
            throw new NumberFormatException("Illegal format of time string");
        }
        StringTokenizer st = new StringTokenizer(time, ":");
        Calendar cal = Calendar.getInstance();
        int i = Integer.parseInt(st.nextToken());
        if (i < 0 || i > 23) {
            throw new NumberFormatException("Hour outside bounds");
        }
        cal.set(11, i);
        i = Integer.parseInt(st.nextToken());
        if (i < 0 || i > 59) {
            throw new NumberFormatException("Minutes outside bounds");
        }
        cal.set(12, i);
        return cal;
    }

    public static boolean checkTimeBetween(Calendar from, Calendar to) {
        Calendar now = Calendar.getInstance();
        int fromHour = from.get(11);
        int fromMinute = from.get(12);
        int toHour = to.get(11);
        int toMinute = to.get(12);
        int nowHour = now.get(11);
        int nowMinute = now.get(12);
        boolean inside = false;
        if (fromHour <= toHour) {
            if (nowHour > fromHour && nowHour < toHour) {
                inside = true;
            } else if (nowHour == fromHour && nowMinute >= fromMinute && nowHour < toHour) {
                inside = true;
            } else if (nowHour > fromHour && nowHour == toHour && nowMinute <= toMinute) {
                inside = true;
            } else if (nowHour == fromHour && nowMinute >= fromMinute && nowHour == toHour && nowMinute <= toMinute) {
                inside = true;
            }
        } else {
            inside = true;
            if (nowHour > toHour && nowHour < fromHour) {
                inside = false;
            } else if (nowHour == toHour && nowMinute > toMinute && nowHour < fromHour) {
                inside = false;
            } else if (nowHour > toHour && nowHour == fromHour && nowMinute < fromMinute) {
                inside = false;
            } else if (nowHour == toHour && nowMinute > toMinute && nowHour == fromHour && nowMinute < fromMinute) {
                inside = false;
            }
        }
        return inside;
    }

    public static Date getSchemaDateVersion(String schema) {
        int lastInd = schema.indexOf(".");
        String schemaVersionString = schema.substring(lastInd - 10, lastInd);
        Date schemaVersionDate = null;
        try {
            schemaVersionDate = DateUtility.DateStringToDate(schemaVersionString);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return schemaVersionDate;
    }
}

