/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.messages.containers;

import java.io.Serializable;
import java.util.Date;
import no.bbs.tt.trustsign.tsm.xml.util.DateUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReminderSettings
implements Serializable {
    private static final long serialVersionUID = 8980127031463147161L;
    private Date startTime = null;
    private int intervalInHours = -1;

    public ReminderSettings() {
    }

    public ReminderSettings(Date startTime, int intervalInHours) {
        this.startTime = startTime;
        this.intervalInHours = intervalInHours;
    }

    public ReminderSettings(Element element) {
        NodeList nl = element.getElementsByTagName("StartTime");
        if (nl.getLength() > 0 && nl.item(0).getFirstChild() != null) {
            String time = nl.item(0).getFirstChild().getNodeValue();
            this.setStartTime(DateUtility.XMLToDate(time));
        }
        if ((nl = element.getElementsByTagName("Interval")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setIntervalInHours(Integer.parseInt(nl.item(0).getFirstChild().getNodeValue()));
        }
    }

    public Element toXML(Document doc) {
        Element root = doc.createElement("ReminderSettings");
        if (null != this.getStartTime()) {
            Element childElement = doc.createElement("StartTime");
            childElement.appendChild(doc.createTextNode(DateUtility.DateToXML(this.getStartTime())));
            root.appendChild(childElement);
            childElement = doc.createElement("Interval");
            childElement.appendChild(doc.createTextNode("" + this.getIntervalInHours()));
            root.appendChild(childElement);
        }
        doc.getFirstChild().appendChild(root);
        return root;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public int getIntervalInHours() {
        return this.intervalInHours;
    }

    public void setIntervalInHours(int intervalInHours) {
        this.intervalInHours = intervalInHours;
    }
}

