/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.sis.esign.demoapp.startup;

import eu.nets.sis.esign.demoapp.DemoAppProperties;
import eu.nets.sis.esign.demoapp.controller.DemoAppController;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ServerSocketFactory;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.startup.Tomcat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerSetup {
    private static final Logger LOGGER = LogManager.getLogger(ServerSetup.class);
    private static final String HOST = "localhost";
    private static final int PORT = DemoAppProperties.port;
    private static final String DOC_BASE = ".";

    public void start() throws IOException {
        Tomcat tomcat = this.createTomcatInstance();
        try {
            tomcat.start();
        }
        catch (LifecycleException exception) {
            System.out.println("Tomcat server startup failed. " + exception.getMessage());
            System.out.println("Exit...");
            System.exit(1);
        }
        LOGGER.info("Application has started with URL " + DemoAppProperties.baseUrl + DemoAppProperties.contextPath);
        this.printBanner();
        System.out.println("\n\nPlease point your preferred browser to " + DemoAppProperties.baseUrl + DemoAppProperties.contextPath);
        tomcat.getServer().await();
    }

    private Tomcat createTomcatInstance() {
        Tomcat tomcat = new Tomcat();
        tomcat.setPort(PORT);
        tomcat.setHostname(HOST);
        tomcat.getHost().setAppBase(DOC_BASE);
        Context context = tomcat.addWebapp("", DOC_BASE);
        tomcat.getConnector();
        this.setController(tomcat, context);
        return tomcat;
    }

    private void setController(Tomcat tomcat, Context context) {
        DemoAppController httpServlet = new DemoAppController();
        String servletName = "demoapp_controller";
        tomcat.addServlet("", servletName, httpServlet);
        context.addServletMappingDecoded(DemoAppProperties.contextPath, servletName);
    }

    public static boolean isPortAvailable() throws IOException {
        boolean bl;
        block8: {
            ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(PORT, 1, InetAddress.getByName(HOST));
            try {
                bl = true;
                if (serverSocket == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (serverSocket != null) {
                        try {
                            serverSocket.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BindException ex) {
                    return false;
                }
            }
            serverSocket.close();
        }
        return bl;
    }

    private void printBanner() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("banner.txt");
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
            String line = br.readLine();
            while (line != null) {
                System.out.println(line);
                line = br.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

