/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.trust.esignclientapi.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class FileUtil {
    public static InputStream getResourceFromStream(String file) throws FileNotFoundException {
        InputStream in = FileUtil.class.getClassLoader().getResourceAsStream(file);
        if (in == null) {
            in = ClassLoader.getSystemResourceAsStream(file);
        }
        if (null == in) {
            try {
                in = new FileInputStream(new File(file));
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return in;
    }

    public String getFileFromStream(String fileName) {
        URL url = this.getClass().getResource("/" + fileName);
        if (null == url) {
            url = this.getClass().getClassLoader().getResource("/" + fileName);
        }
        return url == null ? null : url.getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String fileName, byte[] decodedDoc) {
        FilterOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(new File(fileName)));
            bos.write(decodedDoc);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

