/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.messages.containers;

import java.io.Serializable;
import java.util.ArrayList;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.BankID;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.BankIDNOMobile;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.BankID_SE;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.BankID_SE_Mobile;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.IPKI;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.MitID;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.Nets;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.NotificationChannel;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.PKIOTP;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.Tupas;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Signer
implements Serializable {
    private static final long serialVersionUID = -4359825382853645230L;
    private String localSignerRef = null;
    private String name = null;
    private String merchantSigningPKIType = null;
    private ArrayList<IPKI> acceptedPKIs = null;
    private ArrayList<NotificationChannel> notificationChannels = null;
    private int internalSignerId = -1;
    private boolean merchantSigner = false;
    private String signerStatus = null;

    public Signer() {
    }

    public Signer(Element element) {
        NodeList nodelist = element.getElementsByTagName("MerchantSigner");
        if (null != nodelist && nodelist.getLength() > 0) {
            this.merchantSigner = true;
        } else {
            nodelist = element.getElementsByTagName("EndUserSigner");
        }
        Element signerElement = (Element)nodelist.item(0);
        NodeList nl = signerElement.getElementsByTagName("LocalSignerReference");
        if (nl.getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setLocalSignerRef(nl.item(0).getFirstChild().getNodeValue());
        }
        if (!this.merchantSigner) {
            Element notificationChannelsElem;
            NodeList notificationChannelElems;
            Element notificationElem;
            nl = signerElement.getElementsByTagName("Name");
            if (nl.getLength() > 0 && nl.item(0).getFirstChild() != null) {
                this.setName(nl.item(0).getFirstChild().getNodeValue());
            }
            if (null != (nl = signerElement.getElementsByTagName("AcceptedPKIs")) && nl.getLength() > 0) {
                this.acceptedPKIs = new ArrayList();
                Element acceptedpkisElem = (Element)nl.item(0);
                if (null != (nl = acceptedpkisElem.getElementsByTagName("BankID")) && nl.getLength() > 0) {
                    this.acceptedPKIs.add(new BankID((Element)nl.item(0)));
                }
                if (null != (nl = acceptedpkisElem.getElementsByTagName("BankIDSE")) && nl.getLength() > 0) {
                    this.acceptedPKIs.add(new BankID_SE((Element)nl.item(0)));
                }
                if (null != (nl = acceptedpkisElem.getElementsByTagName("BankIDSEMobile")) && nl.getLength() > 0) {
                    this.acceptedPKIs.add(new BankID_SE_Mobile((Element)nl.item(0)));
                }
                if (null != (nl = acceptedpkisElem.getElementsByTagName("BankIDNOMobile")) && nl.getLength() > 0) {
                    this.acceptedPKIs.add(new BankIDNOMobile((Element)nl.item(0)));
                }
                if (null != (nl = acceptedpkisElem.getElementsByTagName("PKI-OTP")) && nl.getLength() > 0) {
                    this.acceptedPKIs.add(new PKIOTP((Element)nl.item(0)));
                }
                if (null != (nl = acceptedpkisElem.getElementsByTagName("Tupas")) && nl.getLength() > 0) {
                    this.acceptedPKIs.add(new Tupas((Element)nl.item(0)));
                }
                if (null != (nl = acceptedpkisElem.getElementsByTagName("Nets")) && nl.getLength() > 0) {
                    this.acceptedPKIs.add(new Nets((Element)nl.item(0)));
                }
                if (null != (nl = acceptedpkisElem.getElementsByTagName("MitID")) && nl.getLength() > 0) {
                    this.acceptedPKIs.add(new MitID((Element)nl.item(0)));
                }
            }
            if (null != (nl = signerElement.getElementsByTagName("Notification")) && nl.getLength() > 0 && null != (nl = (notificationElem = (Element)nl.item(0)).getElementsByTagName("NotificationChannels")) && nl.getLength() > 0 && null != (notificationChannelElems = (notificationChannelsElem = (Element)nl.item(0)).getElementsByTagName("NotificationChannel")) && notificationChannelElems.getLength() > 0) {
                this.notificationChannels = new ArrayList();
                for (int i = 0; i < notificationChannelElems.getLength(); ++i) {
                    this.notificationChannels.add(new NotificationChannel((Element)notificationChannelElems.item(i)));
                }
            }
        } else {
            nl = signerElement.getElementsByTagName("SigningPKIType");
            if (nl.getLength() > 0 && nl.item(0).getFirstChild() != null) {
                this.setMerchantSigningPKIType(nl.item(0).getFirstChild().getNodeValue());
            }
        }
        if ((nl = element.getElementsByTagName("SignerStatus")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setSignerStatus(nl.item(0).getFirstChild().getNodeValue());
        }
    }

    public String getSignerStatus() {
        return this.signerStatus;
    }

    public void setSignerStatus(String signerStatus) {
        this.signerStatus = signerStatus;
    }

    public String getMerchantSigningPKIType() {
        return this.merchantSigningPKIType;
    }

    public void setMerchantSigningPKIType(String merchantSigningPKIType) {
        this.merchantSigningPKIType = merchantSigningPKIType;
    }

    public boolean isMerchantSigner() {
        return this.merchantSigner;
    }

    public void setMerchantSigner(boolean merchantSigner) {
        this.merchantSigner = merchantSigner;
    }

    public Element toXML(Document doc) {
        Element childElement;
        Element root = doc.createElement("Signer");
        Element signerRootElement = null;
        signerRootElement = this.isMerchantSigner() ? doc.createElement("MerchantSigner") : doc.createElement("EndUserSigner");
        if (null != this.getLocalSignerRef()) {
            childElement = doc.createElement("LocalSignerReference");
            childElement.appendChild(doc.createTextNode(this.getLocalSignerRef()));
            signerRootElement.appendChild(childElement);
        }
        if (!this.isMerchantSigner()) {
            if (null != this.getName()) {
                childElement = doc.createElement("Name");
                childElement.appendChild(doc.createTextNode(this.getName()));
                signerRootElement.appendChild(childElement);
            }
            if (null != this.getAcceptedPKIs() && !this.getAcceptedPKIs().isEmpty()) {
                Element acceptedPKIsElement = doc.createElement("AcceptedPKIs");
                for (int i = 0; i < this.getAcceptedPKIs().size(); ++i) {
                    IPKI tmp = this.getAcceptedPKIs().get(i);
                    if (tmp == null) continue;
                    IPKI pki = tmp;
                    acceptedPKIsElement.appendChild(pki.toXML(doc));
                }
                signerRootElement.appendChild(acceptedPKIsElement);
            }
            if (null != this.getNotificationChannels() && !this.getNotificationChannels().isEmpty()) {
                Element notificationElement = doc.createElement("Notification");
                Element notificationChannelsElement = doc.createElement("NotificationChannels");
                for (int i = 0; i < this.getNotificationChannels().size(); ++i) {
                    NotificationChannel currentChannel = this.getNotificationChannels().get(i);
                    notificationChannelsElement.appendChild(currentChannel.toXML(doc));
                }
                notificationElement.appendChild(notificationChannelsElement);
                signerRootElement.appendChild(notificationElement);
            }
        } else if (null != this.getMerchantSigningPKIType()) {
            childElement = doc.createElement("SigningPKIType");
            childElement.appendChild(doc.createTextNode(this.getMerchantSigningPKIType()));
            signerRootElement.appendChild(childElement);
        }
        root.appendChild(signerRootElement);
        if (null != this.getSignerStatus()) {
            childElement = doc.createElement("SignerStatus");
            childElement.appendChild(doc.createTextNode(this.getSignerStatus()));
            root.appendChild(childElement);
        }
        doc.getFirstChild().appendChild(root);
        return root;
    }

    public int getInternalSignerId() {
        return this.internalSignerId;
    }

    public void setInternalSignerId(int internalSignerId) {
        this.internalSignerId = internalSignerId;
    }

    public ArrayList<NotificationChannel> getNotificationChannels() {
        return this.notificationChannels;
    }

    public void setNotificationChannels(ArrayList<NotificationChannel> notificationChannels) {
        this.notificationChannels = notificationChannels;
    }

    public void addNotificationChannel(NotificationChannel channel) {
        if (null == this.notificationChannels) {
            this.notificationChannels = new ArrayList();
        }
        if (null != channel) {
            this.notificationChannels.add(channel);
        }
    }

    public String getLocalSignerRef() {
        return this.localSignerRef;
    }

    public void setLocalSignerRef(String localSignerRef) {
        this.localSignerRef = localSignerRef;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList<IPKI> getAcceptedPKIs() {
        return this.acceptedPKIs;
    }

    public void setAcceptedPKIs(ArrayList<IPKI> pkis) {
        if (null == pkis || pkis.isEmpty()) {
            return;
        }
        if (null == this.acceptedPKIs) {
            this.acceptedPKIs = new ArrayList();
        }
        for (int i = 0; i < pkis.size(); ++i) {
            IPKI curr = pkis.get(i);
            if (curr == null) continue;
            this.acceptedPKIs.add(curr);
        }
    }

    public void addAcceptedPKI(IPKI pki) {
        if (null == this.acceptedPKIs) {
            this.acceptedPKIs = new ArrayList();
        }
        if (null != pki && !Signer.containsPki(this.acceptedPKIs, pki)) {
            this.acceptedPKIs.add(pki);
        }
    }

    private static boolean containsPki(ArrayList<IPKI> acceptedPKIs, IPKI addPki) {
        if (acceptedPKIs != null) {
            for (IPKI pki : acceptedPKIs) {
                if (pki.getPKIVendor() != addPki.getPKIVendor()) continue;
                return true;
            }
        }
        return false;
    }
}

