<!DOCTYPE html>
<html lang="en">
	<head>
		<title>E-Sign Demo App</title>
		<meta name="viewport" content="user-scalable=yes, initial-scale=1.0, width=device-width">
		<meta http-equiv="content-Type" content="text/html; charset=UTF-8">
		<meta http-equiv="Pragma" content="no-cache">
		<meta http-equiv="Cache-Control" content="no-cache">
		<link rel="SHORTCUT ICON" href="/images/in-groupe-favicon.png">
		<link rel="stylesheet" type="text/css" href="/css/global.css">
		<script type="text/javascript" src="/js/status.js"></script>
	</head>
	
	<body>
		<#include "header.ftl">
		
		<div class="maintable" id="status" data-esign-path=${baseUrl}>
			<#if status == "completed">
			<div id="successBlock" class="response-message">
				<h2 class="heading">Signing completed successfully</h2>
		
				<div id="description">
					<span>You have now signed the document successfully.</span><span>The
						document is stored in the E-Signing service for a period of time,
						from where it can be fetched by you using the GetSDO call to
						E-Signing.</span><span> It can also be archived to E-Archive for
						long time storage.</span>
				</div>
			</div>
			<#else>
			<div id="failureBlock" class="response-message">
				<h2 class="heading">Signing was not completed</h2>
		
				<div id="description">
					<span>The signing was not completed successfully. Please try again.</span>
				</div>
			</div>
			</#if>
		</div>
		
		<#include "footer.ftl">
	</body>
</html>